% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resourcePotential.R
\name{resourcePotential}
\alias{resourcePotential}
\title{Calculates the Resource Potential of species groups}
\usage{
resourcePotential(X, groups, species.table = NULL, metric = "BIOMASS",
  years)
}
\arguments{
\item{X}{A dataframe of fishery independent data derived from research vessel
survey data or model output, with columns \code{YEAR}, \code{ID},
\code{SPECIES}, and \code{BIOMASS} or \code{ABUNDANCE}. \code{YEAR}
indicates the year the observation was recorded, \code{ID} is an area code
indicating where the observation was recorded, \code{SPECIES} is a numeric
code indicating the species sampled, and \code{BIOMASS}/\code{ABUNDANCE} is
the corresponding biomass/abundance (stratified and corrected for
catchability as required).}

\item{groups}{A vector indicating the species group(s) for which to calculate
the indicator. If \code{groups = "ALL"}, all species will be included;
otherwise, each entry must be a character string matching the name of a
column in \code{species.table}.}

\item{species.table}{A table where the column names match the entries in
\code{groups}. Column entries are species codes indicating the species from
\code{X} included in each group. \code{species.table} may also include
columns for other species groups; these will be ignored. If \code{groups =
"ALL"}, this table is not required. Default is \code{species.table = NULL}.}

\item{metric}{A character string indicating which column in \code{X} to use to
calculate indicator. Default is \code{metric = "BIOMASS"}.}

\item{years}{A vector of years for which to calculate indicator.}
}
\value{
Returns a dataframe with columns \code{ID} and \code{YEAR}, and a
 column \code{metric_group} (e.g., \code{BIOMASS_FINFISH}) for each entry in
 \code{groups}.

 If there is no data for a given year, the indicator value will be \code{NA}
 for that year.
}
\description{
This function calculates the Biomass or Abundance of a
 pre-defined group of species for \eqn{j} areas and \eqn{i} years.
}
\details{
This indicator reflects temporal dynamics of species groups.
}
\examples{
# Compile data
data(X)
data(species.table)

# Calculate total abundance and biomass
resourcePotential(X, groups = "ALL", metric = "ABUNDANCE", years = c(2014:2019))
resourcePotential(X, groups = "ALL", metric = "BIOMASS", years = c(2014:2019))

# Calculate biomass of trophic guilds
trophicguild.groups <- c("LBENTHIVORE", "MBENTHIVORE", "PISCIVORE", "PLANKTIVORE", "ZOOPISCIVORE")
resourcePotential(X, groups = trophicguild.groups,
   species.table = species.table, metric = "BIOMASS", years = c(2014:2019))

# Calculate biomass of fished groups
resource.groups <- c("ALL", "CLUPEIDS", "FINFISH", "FLATFISH", "FORAGE", "GADOIDS", "GROUNDFISH")
resourcePotential(X, groups = resource.groups, species.table = species.table,
   metric = "BIOMASS", years = c(2014:2019))
}
\references{
Bundy A, Gomez C, Cook AM. 2017. Guidance framework for the
 selection and evaluation of ecological indicators. Can. Tech. Rep. Fish.
 Aquat. Sci. 3232: xii + 212 p.
}
\seealso{
Other resource potential indicators: \code{\link{allPotential}},
  \code{\link{fishingInBalance}}
}
\author{
Danielle Dempsey \email{Danielle.Dempsey@dfo-mpo.gc.ca}, Adam Cook,
 Catalina Gomez, Alida Bundy
}
\concept{ecosystem structure and functioning indicators}
\concept{resource potential indicators}
