% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IVILandings.R
\name{IVILandings}
\alias{IVILandings}
\title{Calculates the Intrinsic Vulnerability Index of commercial landings}
\usage{
IVILandings(land, IVI.table, negative = FALSE, years)
}
\arguments{
\item{land}{A dataframe of commercial landings data with columns \code{YEAR},
\code{ID}, \code{SPECIES} and \code{CATCH}. \code{YEAR} indicates the year
the landing was recorded, \code{ID} is an area code indicating where the
landing was recorded, \code{SPECIES} is a numeric code indicating the
species landed, and \code{CATCH} is the corresponding landed weight.}

\item{IVI.table}{A dataframe with columns \code{SPECIES} and the corresponding
\code{IVI} (intrinsic vulnerability index). Entries in the \code{SPECIES}
column should be the unique values of species codes in \code{land} (or a
subset thereof). Other columns in \code{IVI.table} are ignored.}

\item{negative}{If \code{negative = TRUE}, the indicator will be multiplied by
-1 so that the expected response is to decrease with increasing fishing
pressure. Default is \code{negative = FALSE}.}

\item{years}{A vector of years for which to calculate indicator.}
}
\value{
Returns a dataframe with three columns: \code{ID}, \code{YEAR}, and
 \code{IVILandings}.

 If there are no observations in \code{land} for spatial scale \eqn{j} in
 year \eqn{i}, indicator value is assigned \code{NA}.
}
\description{
This function calculates the Intrinsic Vulnerability Index (IVI)
 of the commercial landings for \eqn{j} areas and \eqn{i} years.
}
\details{
The weighted Intrinsic Vulnerability Index (IVI) of species in the
 commercial landings was estimated as: \deqn{IVI = \Sigma(IVI_j * C_j)/\Sigma
 C_j} where the sum is over all species, \eqn{j}. The vulnerability for each
 species was determined by considering several traits including maximum
 length, age at first maturity, longevity, von Bertalanffy growth parameter,
 natural mortality, fecundity, spatial behaviour and geographic range (e.g.
 species with larger body size, higher longevity, higher age at maturity, and
 lower growth rates have higher vulnerability indexes and should be less able
 to sustain high fishing mortality; Cheung et al. 2005). The index values
 ranges from 1 to 100, with 100 being the most vulnerable. See Appendix 1
 from Cheung et al., 2007:
 \url{http://www.int-res.com/articles/suppl/m333p001_app.pdf}
}
\examples{
# Compile data
data(land)
data(species.info)

# Calculate indicator
IVILandings(land, IVI.table = species.info, negative = TRUE, years = c(2014:2019))
}
\references{
Bundy A, Gomez C, Cook AM. 2017. Guidance framework for the
 selection and evaluation of ecological indicators. Can. Tech. Rep. Fish.
 Aquat. Sci. 3232: xii + 212 p.

 Cheung WWL, Pitcher TJ, Pauly D. 2005. A fuzzy logic expert system to
 estimate intrinsic extinction vulnerability of marine fishes to fishing.
 Biol Conserv 124:97–111

 Cheung WWL, Watson R, Morato T, Pitcher, TJ, Pauly, D. 2007. Intrinsic
 vulnerability in the global fish catch. Mar Ecol Prog Ser 333: 1 - 12
}
\seealso{
Other stability and resistance indicators: \code{\link{CVBiomass}},
  \code{\link{allStability}}, \code{\link{biomassPerTL}},
  \code{\link{meanMaxAge}}, \code{\link{meanMaxLength}}
}
\author{
Danielle Dempsey \email{Danielle.Dempsey@dfo-mpo.gc.ca}, Adam Cook,
 Catalina Gomez, Alida Bundy
}
\concept{stability and resistance indicators}
