% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/popup.R
\name{popupTable}
\alias{popupTable}
\alias{popupImage}
\alias{popupGraph}
\title{Create HTML strings for popups}
\usage{
popupTable(x, zcol, row.numbers = TRUE, feature.id = TRUE)

popupImage(img, src = c("local", "remote"), embed = FALSE, ...)

popupGraph(graphs, type = c("png", "svg", "html"), width = 300,
  height = 300, ...)
}
\arguments{
\item{x}{A \code{Spatial*} object.}

\item{zcol}{\code{numeric} or \code{character} vector indicating the columns
included in the output popup table. If missing, all columns are displayed.}

\item{row.numbers}{\code{logical} whether to include row numbers in the popup table.}

\item{feature.id}{\code{logical} whether to add 'Feature ID' entry to popup table.}

\item{img}{A character \code{vector} of file path(s) or
web-URL(s) to any sort of image file(s).}

\item{src}{Whether the source is "local" (i.e. valid file path(s)) or
"remote" (i.e. valid URL(s)).}

\item{embed}{whether to embed the (local) images in the popup html as
base64 ecoded. Set this to TRUE if you want to save and share your map, unless
you want render many images, then set to FALSE and make sure to copy ../graphs
when copying the map to a different location.}

\item{...}{further arguments passed on to underlying methods such as
height and width.}

\item{graphs}{A \code{list} of figures associated with \code{x}.}

\item{type}{Output filetype, one of "png" (default), "svg" or "html".}

\item{width}{popup width in pixels.}

\item{height}{popup height in pixels.}
}
\description{
These functions are deprecated.
Please use leafpop::\code{\link[leafpop]{popupTable}},
leafpop::\code{\link[leafpop]{popupImage}}
and leafpop::\code{\link[leafpop]{popupGraph}} instead.
}
