% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/options.R
\name{mapviewOptions}
\alias{mapviewOptions}
\alias{mapviewGetOption}
\title{Global options for the mapview package}
\usage{
mapviewOptions(
  platform,
  basemaps,
  basemaps.color.shuffle,
  raster.palette,
  vector.palette,
  verbose,
  na.color,
  legend,
  legend.opacity,
  legend.pos,
  layers.control.pos,
  leafletWidth,
  leafletHeight,
  viewer.suppress,
  homebutton,
  homebutton.pos,
  native.crs,
  raster.size,
  mapview.maxpixels,
  plainview.maxpixels,
  use.layer.names,
  trim,
  method,
  query.type,
  query.digits,
  query.position,
  query.prefix,
  maxpoints,
  maxpolygons,
  maxlines,
  pane,
  cex,
  alpha,
  default = FALSE,
  console = TRUE,
  watch = FALSE,
  fgb,
  georaster
)

mapviewGetOption(param)
}
\arguments{
\item{platform}{character. The rendering platform to be used.
Current options are "leaflet", "mapdeck", and "leafgl".}

\item{basemaps}{character. The basemaps to be used for rendering data. See
\url{https://leaflet-extras.github.io/leaflet-providers/preview/} for possible
values}

\item{basemaps.color.shuffle}{logical. Should basemaps order be changed to
enhance contrast based on layer coloring. Set to FALSE if you supply custom
basemaps or want to ensure that "CartoDB.Positron" is always the default.}

\item{raster.palette}{a color palette function for raster visualisation.
Should be a function that takes an integer as input and returns a vector of colors.
See \code{\link{colorRampPalette}} for details.}

\item{vector.palette}{a color palette function for vector visualisation.
Should be a function that takes an integer as input and returns a vector of colors.
See \code{\link{colorRampPalette}} for details.}

\item{verbose}{logical. Many functions in mapview provide details about their
behaviour. Set this to TRUE if you want to see these printed to the console.}

\item{na.color}{character. The default color to be used for NA values.}

\item{legend}{logical. Whether or not to show a legend for the layer(s).}

\item{legend.opacity}{opacity of the legend.}

\item{legend.pos}{Where should the legend be placed?
One of "topleft", "topright", "bottomleft", "bottomright".}

\item{layers.control.pos}{character. Where should the layer control be
placed? One of "topleft", "topright", "bottomleft", "bottomright".}

\item{leafletWidth, leafletHeight}{height and width of the htmlwidget in px.}

\item{viewer.suppress}{whether to render the map in the browser (\code{TRUE})
or the RStudio viewer (\code{FALSE}).}

\item{homebutton}{logical, whether to add a zoom-to-layer button to the map.}

\item{homebutton.pos}{character. Where should the homebutton(s) be
placed? One of "topleft", "topright", "bottomleft", "bottomright".}

\item{native.crs}{logical whether to reproject to web map coordinate
reference system (web mercator - epsg:3857) or render using native CRS of
the supplied data (can also be NA). Default is FALSE which will render in
web mercator. If set to TRUE now background maps will be drawn (but rendering
may be much quicker as no reprojecting is necessary).}

\item{raster.size}{numeric. see the maxBytes argument in \code{\link{addRasterImage}}}

\item{mapview.maxpixels}{numeric. The maximum amount of pixels allowed for Raster*
objects to be rendered with \code{mapview}. Defaults to 500000.
Set this higher if you have a potent machine or are patient enough to wait a little.}

\item{plainview.maxpixels}{numeric. The maximum amount of pixels allowed for Raster*
objects to be rendered with \code{plainview}. Defaults to 10000000.
Set this higher if you have a potent machine or are patient enough to wait a little.}

\item{use.layer.names}{whether to use layer names when plotting raster layers.}

\item{trim}{should the raster be trimmed in case there are NAs on the edges.}

\item{method}{for raster data only (raster/stars). Method used to compute
values for the resampled layer that is passed on to leaflet. mapview does
projection on-the-fly to ensure correct display and therefore needs to know
how to do this projection. The default is 'bilinear' (bilinear interpolation),
which is appropriate for continuous variables. The other option, 'ngb'
(nearest neighbor), is useful for categorical variables. Ignored if the raster
layer is of class \code{factor} in which case "ngb" is used.}

\item{query.type}{for raster methods only. Whether to show raster value query
on \code{'mousemove'} or \code{'click'}. Ignored if \code{label = FALSE}.}

\item{query.digits}{for raster methods only. The amount of digits to be shown
by raster value query. Ignored if \code{label = FALSE}.}

\item{query.position}{for raster methods only. The position of the raster
value query info box. See \code{position} argument of \code{\link{addLegend}}
for possible values. Ignored if \code{label = FALSE}.}

\item{query.prefix}{for raster methods only. a character string to be shown
as prefix for the layerId. Ignored if \code{label = FALSE}.}

\item{maxpoints}{numeric. Maximum number of points allowed for leaflet overlay
rendering. If this number is exceeded rendering will be done
using special functionality which will provide much more speed and better handling.
This means that standard functionality is reduced.
For example adding layers via "+" is not possible anymore.}

\item{maxpolygons}{numeric. Maximum number of polygons allowed for leaflet overlay
rendering. If this number is exceeded rendering will be done
using special functionality which will provide much more speed and better handling.
This means that standard functionality is reduced.
For example adding layers via "+" is not possible anymore.}

\item{maxlines}{numeric. Maximum number of lines allowed for leaflet overlay
rendering. If this number is exceeded rendering will be done
using special functionality which will provide much more speed and better handling.
This means that standard functionality is reduced.
For example adding layers via "+" is not possible anymore.}

\item{pane}{name of the map pane in which to render features. See
\code{\link{addMapPane}} for details. Currently only supported for vector layers.
Ignored if \code{canvas = TRUE}. The default \code{"auto"} will create different panes
for points, lines and polygons such that points overlay lines overlay polygons.
Set to \code{NULL} to get default leaflet behaviour where allfeatures
are rendered in the same pane and layer order is determined automatically/sequentially.}

\item{cex}{numeric or attribute name(s) or column number(s) in attribute table
of the column(s) to be used for defining the size of circles.}

\item{alpha}{opacity of lines.}

\item{default}{logical. If TRUE all options are set to their default values}

\item{console}{logical. Should the options be printed to the console}

\item{watch}{whether to watch a certain environment and automatically
render changes to the list of spatial data in that environment. See
\link{mapviewWatcher} for details.}

\item{fgb}{if set to \code{TRUE} mapview will not use 'clasical' leaflet/htmlwidgets
rendering (which embeds data directly in the html) but leverage the speed of
a file format called flatgeobuf (hence, fgb). This has the added benefit that
data is being streamed onto the map, which makes for a pleasant user experience.
It should also help to visualise larger data sets due to a reduced memeory footprint.
A note of warning, data will be attached to the html
via a <src=...> call which means that the html is not selfcontained anymore
(so it cannot be used without an accompanying folder).}

\item{georaster}{whether to use \code{\link[leafem]{addGeoRaster}} instead of
\code{\link[leaflet]{addRasterImage}}. If set to \code{TRUE} raster image visualisation
 will be more performant for large raster data, but given the nearest neighbor
 resampling results may be slightly distorted.}

\item{param}{character. parameter(s) to be queried.}
}
\value{
list of the current options (invisibly).
If no arguments are provided the options are printed.
}
\description{
To permanently set any of these options, you can add them to
<your R installation>/etc/Rprofile.site>. For example,
to change the default number of pixels to be visualised for Raster* objects,
add a line like this: options(mapviewMaxPixels = 700000) to that file.
}
\section{Functions}{
\itemize{
\item \code{mapviewGetOption}: query mapviewOptions parameters.
}}

\examples{
mapviewOptions()
mapviewOptions(na.color = "pink")
mapviewOptions()

mapviewGetOption("platform")

mapviewOptions(default = TRUE)
mapviewOptions()


}
\seealso{
\code{\link{rasterOptions}}, \code{\link{options}}
}
\author{
Tim Appelhans
}
