% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cartography_chamber.R
\name{create_ball_mapper_object}
\alias{create_ball_mapper_object}
\title{Run mapper using a trivial filter, a cover of balls, and no clustering algorithm.}
\usage{
create_ball_mapper_object(data, dists, eps)
}
\arguments{
\item{data}{A data frame.}

\item{dists}{A distance matrix for the data frame.}

\item{eps}{A positive real number for your desired ball radius.}
}
\value{
A list of two data frames, one with node data containing ball size,
data points per ball, ball tightness, and one with edge data
containing sources, targets, and weights representing overlap strength.
}
\description{
Run mapper using an \eqn{\varepsilon}-net cover (greedily generated) and the 2D inclusion function as a filter.
}
\examples{
data = data.frame(x = sapply(1:100, function(x) cos(x)), y = sapply(1:100, function(x) sin(x)))
eps = .5

create_ball_mapper_object(data, dist(data), eps)
}
