% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/style_helpers.R
\name{step_expr}
\alias{step_expr}
\title{Create a step expression}
\usage{
step_expr(column = NULL, property = NULL, base, values, stops, na_color = NULL)
}
\arguments{
\item{column}{The name of the column to use for the step expression. If specified, \code{property} should be NULL.}

\item{property}{The name of the property to use for the step expression. If specified, \code{column} should be NULL.}

\item{base}{The base value to use for the step expression.}

\item{values}{A numeric vector of values at which steps occur.}

\item{stops}{A vector of corresponding stops (colors, sizes, etc.) for the steps.}

\item{na_color}{The color to use for missing values.  Mapbox GL JS defaults to black if this is not supplied.}
}
\value{
A list representing the step expression.
}
\description{
This function generates a step expression that can be used in your styles.
}
\examples{
step_expr(
    column = "value",
    base = "#ffffff",
    values = c(1000, 5000, 10000),
    stops = c("#ff0000", "#00ff00", "#0000ff")
)
}
