% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/controls.R
\name{add_geocoder_control}
\alias{add_geocoder_control}
\title{Add a geocoder control to a map}
\usage{
add_geocoder_control(
  map,
  position = "top-right",
  placeholder = "Search",
  collapsed = FALSE,
  provider = NULL,
  maptiler_api_key = NULL,
  ...
)
}
\arguments{
\item{map}{A map object created by the \code{mapboxgl} or \code{maplibre} function.}

\item{position}{The position of the control. Can be one of "top-left", "top-right", "bottom-left", or "bottom-right". Default is "top-right".}

\item{placeholder}{A string to use as placeholder text for the search bar. Default is "Search".}

\item{collapsed}{Whether the control should be collapsed until hovered or clicked. Default is FALSE.}

\item{provider}{The geocoding provider to use for MapLibre maps. Either "osm" for OpenStreetMap/Nominatim or "maptiler" for MapTiler geocoding. If NULL (default), MapLibre maps will use "osm". Mapbox maps will always use the Mapbox geocoder, regardless of this parameter.}

\item{maptiler_api_key}{Your MapTiler API key (required when provider is "maptiler" for MapLibre maps). Can also be set with \code{MAPTILER_API_KEY} environment variable. Mapbox maps will always use the Mapbox API key set at the map level.}

\item{...}{Additional parameters to pass to the Geocoder.}
}
\value{
The modified map object with the geocoder control added.
}
\description{
This function adds a Geocoder search bar to a Mapbox GL or MapLibre GL map.
By default, a marker will be added at the selected location and the map will
fly to that location.  The results of the geocode are accessible in a Shiny
session at \code{input$MAPID_geocoder$result}, where \code{MAPID} is the name of your map.
}
\examples{
\dontrun{
library(mapgl)

mapboxgl() |>
    add_geocoder_control(position = "top-left", placeholder = "Enter an address")

maplibre() |>
    add_geocoder_control(position = "top-right", placeholder = "Search location")

# Using MapTiler geocoder
maplibre() |>
    add_geocoder_control(provider = "maptiler", maptiler_api_key = "YOUR_API_KEY")
}
}
