% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/q_mediation_plot.R
\name{plot.q_mediation}
\alias{plot.q_mediation}
\alias{indirect_on_plot}
\title{Plot Method for the Output
of 'q_mediation' Family}
\usage{
\method{plot}{q_mediation}(
  x,
  standardized = FALSE,
  size_variables = NULL,
  size_path_labels = NULL,
  nchar_variables = NULL,
  nchar_path_labels = NULL,
  digits = 2,
  rsquares = TRUE,
  sigs = TRUE,
  margins = c(5, 5, 5, 5),
  v_pos = c("middle", "lower", "upper"),
  v_preference = c("upper", "lower"),
  print_indirect = TRUE,
  indirect_standardized = c("none", "stdx", "stdy", "stdxy"),
  size_indirect = 1,
  plot_now = TRUE,
  ...
)

indirect_on_plot(
  q_mediation_output = NULL,
  digits = 2,
  size_indirect = 1,
  indirect_standardized = c("none", "stdx", "stdy", "stdxy"),
  margins = c(5, 5, 5, 5),
  original_plot = NULL
)
}
\arguments{
\item{x}{The output of
\code{\link[=q_mediation]{q_mediation()}},
\code{\link[=q_simple_mediation]{q_simple_mediation()}},
\code{\link[=q_serial_mediation]{q_serial_mediation()}}, and
\code{\link[=q_parallel_mediation]{q_parallel_mediation()}}.
(Named \code{x}
because it is required in the naming
of arguments of the \code{plot} generic
function.)}

\item{standardized}{Logical. If
\code{TRUE}, \code{betaS} in the printout of
\code{\link[=q_mediation]{q_mediation()}} family will be used
in the figure, with only numerical
variables standardized. If \code{FALSE},
the default, then the original
(unstandardized) coefficients will
be used.}

\item{size_variables}{The size of
the observed variables (the
"rectangles"), to be passed
to \code{sizeMan} of
\code{\link[semPlot:semPaths]{semPlot::semPaths()}}. Default is
\code{NULL} and the size is determined
internally based on the number of
variables.}

\item{size_path_labels}{The size of
the edge labels (parameter
estimates), to be passed to
\code{edge.label.cex} of
\code{\link[semPlot:semPaths]{semPlot::semPaths()}}. Default is
\code{NULL} and the size is determined
internally based on the number of
variables in the plot.}

\item{nchar_variables}{The number of
characters to be displayed for each
variable. To be passed to
\code{nCharNodes} of
\code{\link[semPlot:semPaths]{semPlot::semPaths()}}. Default is
\code{NULL}, equivalent to \code{0} for
\code{nCharNodes}, to disable abbreviating
the variable names.}

\item{nchar_path_labels}{The number
of characters to be displayed for
each label for a path. To be passed
to \code{nCharEdges} of
\code{\link[semPlot:semPaths]{semPlot::semPaths()}}. Default is
\code{NULL}, equivalent to \code{0} for
\code{nCharEdges}, to disable
abbreviating the labels.}

\item{digits}{The number
of digits to be printed after the
decimals. To be passed
to \code{nDigits} of
\code{\link[semPlot:semPaths]{semPlot::semPaths()}}. Default is
2.}

\item{rsquares}{Logical. If \code{TRUE},
the default, R-squares will be
drawn instead of error variances for
mediators and outcome variables
(the \code{y} variables).}

\item{sigs}{Logical. If \code{TRUE}, the
default, significance test results
will be marked by asterisks, based on
the same \emph{p}-values for R-squares
displayed when printing the output of
the \code{\link[=q_mediation]{q_mediation()}} family.}

\item{margins}{The margins of the plot.
A numeric vector of four values:
bottom, left, top, and right. Passed
to the \code{mar} argument of
\code{\link[semPlot:semPaths]{semPlot::semPaths()}}.}

\item{v_pos}{How the mediators are to
be positioned vertically. If set to
\code{"middle"}, with one \code{x} variable and
one \code{y} variable, the mediators will
tend to be placed around the
horizontal line joining \code{x} and \code{y}.
If set to \code{"upper"}, they will be
placed along or above this line. If
set to \code{"lower"}, they will be placed
along or below this line. Note that
this only affects the initial positions.
The positions will be further adjusted
based on the free paths in the model.
This argument is to be passed to
\code{\link[semptools:auto_layout_mediation]{semptools::auto_layout_mediation()}}.}

\item{v_preference}{The preference in
shifting the mediators upward
(\code{"upper"}) or downward (\code{"lower"})
to avoid blocking or overlapping with
any paths in the models. It is used
only when\code{v_pos} is \code{"middle"}. If
\code{v_pos} is \code{"lower"}, then
\code{v_preference} will be forced to be
\code{"lower"}. If \code{v_pos} is \code{"upper"},
then \code{v_preference} will be forced to
be \code{"upper"}. This argument is to be
passed to
\code{\link[semptools:auto_layout_mediation]{semptools::auto_layout_mediation()}}.}

\item{print_indirect}{Logical.
Whether the indirect effect(s), and
total indirect effect if applicable,
will be printed on the plot. Default
is \code{TRUE}. Used only if \code{plot_now}
is \code{TRUE}. Confidence intervals,
if stored, will be printed, at
the level of confidence used when
doing the analysis.}

\item{indirect_standardized}{If
\code{print_indirect} is \code{TRUE}, which
type of
effects are to be printed: \code{"none"}
for the unstandardized (raw) indirect
effects, \code{"stdx"} for the effects with
\code{x} standardized, \code{"stdy"} for the
effects with \code{y} standardized, and
\code{"stdxy"} for the effects with both
\code{x} and \code{y} standardized.}

\item{size_indirect}{The size used
when printing the indirect effects.
The final size is determined by
multiplying the final
value \code{size_path_labels} (determined
internally if it is set to \code{NULL})
by this value. If equal to 1, then
the size used in printing the
indirect effects should be "close"
to the size of numbers on the paths.}

\item{plot_now}{If \code{TRUE}, the default,
the plot will be plotted when calling
this method.}

\item{...}{For the \code{plot} method,
these are optional arguments to be
passed to \code{\link[semPlot:semPaths]{semPlot::semPaths()}} to
generate the initial plot, before
being adjusted by
\code{\link[semptools:auto_layout_mediation]{semptools::auto_layout_mediation()}}.}

\item{q_mediation_output}{The original
object used to generate the plot
(the output of the \code{\link[=q_mediation]{q_mediation()}}
family).
Indirect effects will be retrieved
from this output.}

\item{original_plot}{The plot
generated by the \code{plot} method. If
supplied, a new plot will be
generated and then the indirect
effects will be printed on this new
plot. If \code{NULL}, the default, the
indirect effects will be printed on
the existing plot. Space will be
added to make room for the
indirect effects only if this
argument is set. If \code{original_plot}
is not used, make sure there is
enough room at the bottom for the
indirect effects.}
}
\value{
The \code{plot} method returns a \code{qgraph}
object generated
by \code{\link[semPlot:semPaths]{semPlot::semPaths()}}, which is
plotted by default unless \code{plot_now}
is set to \code{FALSE}. It can be further
modified by other functions that
work on a \code{qgraph} object, such as
those from \code{semptools}.

The function \code{\link[=indirect_on_plot]{indirect_on_plot()}}
returns the object set to
\code{q_mediation_output}
invisibly. It is called for its
side-effect.
}
\description{
Plot the path model
fitted by the family of 'q_mediation'
functions.
}
\details{
This method requires the
\code{semptools} and \code{semPlot} packages.
They are not installed by default.
Install them first before using the
plot method.

This method draws the path models
fitted by \code{\link[=q_mediation]{q_mediation()}},
\code{\link[=q_simple_mediation]{q_simple_mediation()}},
\code{\link[=q_serial_mediation]{q_serial_mediation()}}, and
\code{\link[=q_parallel_mediation]{q_parallel_mediation()}}, with
path coefficients and R-squares.

It will try to set positions of the
variables automatically, following
the left-to-right convention: \code{x}
variables on the left, \code{y} variables
on the right, mediators between them,
and arrows (paths) flow from left to
right. The figure should usually be
usable. If not, it can be further
modified by helper functions such as
those in \code{semptools} that can
manipulate a \code{qgraph} object. For
example, \code{\link[semptools:move_node]{semptools::move_node()}}
can be used to adjust the position
of a variable in the plot.

The helper function \code{\link[=indirect_on_plot]{indirect_on_plot()}}
adds the indirect effect
estimates (as well as confidence
intervals and \emph{p}-values, if
available) to a plot. The \code{plot} method
will add these effects by default,
and so users usually do not need to
use this function.
However, if the plot needs to be modified
before being drawn, this function
can be used to add the effects
after drawing the modified plot.
}
\examples{

# These examples require the package
# semptools (version 0.3.2 or above).

# CI disabled in these examples.
# Please see the help page of these functions on forming
# confidence intervals for the indirect effects.

# ===== Simple mediation

out <- q_simple_mediation(x = "x",
                          y = "y",
                          m = "m",
                          cov = c("c2", "c1"),
                          boot_ci = FALSE,
                          data = data_med)
plot(out)

# ===== Serial mediation

out <- q_serial_mediation(x = "x",
                          y = "y",
                          m = c("m1", "m2"),
                          cov = c("c2", "c1"),
                          boot_ci = FALSE,
                          data = data_serial)
plot(out)
# Standardized effects
plot(out,
     standardized = TRUE,
     indirect_standardized = "stdxy")

# ==== Parallel mediation

out <- q_parallel_mediation(x = "x",
                            y = "y",
                            m = c("m1", "m2"),
                            cov = c("c2", "c1"),
                            boot_ci = FALSE,
                            data = data_parallel)

plot(out)
plot(out,
     v_pos = "lower")
plot(out,
     v_pos = "upper")

# ===== A user-specified mediation model

out <- q_mediation(x = "x1",
                   y = "y1",
                   model = c("x1 -> m11 -> m2 -> y1",
                             "x1 -> m12 -> m2 -> y1"),
                   cov = c("c2", "c1"),
                   boot_ci = FALSE,
                   data = data_med_complicated)
plot(out)

}
