% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/na_replace_grouped.R
\name{na_replace_grouped}
\alias{na_replace_grouped}
\title{Replace NAs by group}
\usage{
na_replace_grouped(df, group_by_cols = NULL, ...)
}
\arguments{
\item{df}{A data.frame object for which grouped NA replacement is desired.}

\item{group_by_cols}{The column(s) used to use for the grouping.}

\item{...}{Other arguments to `na_replace`}
}
\value{
A `data.frame` object with `NA`s replaced.
}
\description{
A convenient way to replace NAs by group.
}
\examples{
test2 <- data.frame(A=c("A","A","A","B","B","B"),
B=c(NA,5,2,2,NA,2))
head(na_replace_grouped(test2,"A",
how="value","Replaced"))
test <- data.frame(groups=c("A","A","A","B","B","B"),
                  values = c(1,NA,2,1,NA,NA))

 na_replace_grouped(test,"groups",how="mean")
}
