% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.vector.points.R
\name{autoplot.vector.points}
\alias{autoplot.vector.points}
\title{Create a basic plot showing locations of downloaded Vector points}
\usage{
\method{autoplot}{vector.points}(object, ..., shp_df = NULL,
  admin_level = "admin0", map_title = "Vector Survey Locations",
  fill_legend_title = "Raw Vetor Occurrences",
  fill_scale_transform = "identity", facet = NULL, printed = TRUE)
}
\arguments{
\item{object}{a vector.points object downloaded using /code{/link{getVecOcc}}}

\item{...}{Other arguments passed to specific methods}

\item{shp_df}{Shapefile(s) (data.frame) to plot with downloaded points. (If not specified automatically uses getShp() for all countries included in vector.points object).}

\item{admin_level}{the administrative level used for plotting administrative boundaries; either /code{"admin0"}; /code{"admin1"} OR /code{"both"}}

\item{map_title}{custom title used for the plot}

\item{fill_legend_title}{Add a title to the legend.}

\item{fill_scale_transform}{String givning a transformation for the fill aesthetic.
See the trans argument in \code{\link{continuous_scale}} for possible values.}

\item{facet}{if TRUE, splits map into a separate facet for each malaria species; by default FALSE.}

\item{printed}{Should the plot be printed to the graphics device.}
}
\value{
\code{autoplot.vector.points} returns a plots (gg object) for the supplied vector.points dataframe.
}
\description{
\code{autoplot.vector.points} creates a map of Vector points downloaded from MAP.
}
\examples{
\donttest{
Vector_surveys_NGA_NG <- getVecOcc(country = c("Nigeria", "Niger"))
autoplot(Vector_surveys_NGA_NG)

# Download the predicted distribution of An. dirus species complex Raster and  
#  vector points for Myanmar and visualise these together on a map.

# Download Myanmar shapefile to use for raster download.
MMR_shp <- getShp(ISO = "MMR", admin_level = "admin0")
MMR_shp_df <- as.MAPshp(MMR_shp)

# Download An. dirus predicted distribution Raster & plot this
MMR_An_dirus <- getRaster(surface = "Anopheles dirus species complex", shp = MMR_shp)
MMR_An_dirus_df <- as.MAPraster(MMR_An_dirus)
p <- autoplot_MAPraster(MMR_An_dirus, shp_df = MMR_shp_df, printed = FALSE)

# Download raw occurrence points & plot these over the top of the raster   
species <- getVecOcc(country = "Myanmar", species = "Anopheles dirus")
p[[1]] +
geom_point(data = species,
 aes(longitude,
  latitude,
  colour = species))+
  scale_colour_manual(values = "black", name = "Vector suvery locations")+
scale_fill_distiller(name = "Predicted distribution of An. dirus complex",
 palette = "PuBuGn",
  direction = 1)+
  ggtitle("Vector Survey points\\n + The predicted distribution of An. dirus complex")
}

}
