% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.MAPshp.R
\name{autoplot.MAPshp}
\alias{autoplot.MAPshp}
\title{Create a basic plot to visualise downloaded shapefiles}
\usage{
\method{autoplot}{MAPshp}(object, ..., map_title = NULL, facet = FALSE,
  printed = TRUE)
}
\arguments{
\item{object}{A MAPShp object downloaded using /code{/link{getShp}} with format = "df" specified.}

\item{...}{Other arguments passed to specific methods}

\item{map_title}{Custom title used for the plot.}

\item{facet}{If TRUE, splits map into a separate facet for each malaria species.}

\item{printed}{Should the plot print to graphics device.}
}
\value{
\code{autoplot.MAPshp} returns a map (gg object) of the supplied MAPShp dataframe.
}
\description{
\code{autoplot.MAPshp} creates a map of shapefiles downloaded using getShp.
}
\examples{
\donttest{
MDG_shp <- getShp(ISO = "MDG", admin_level = "admin0")
autoplot(as.MAPshp(MDG_shp))
}

}
