% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{population_populate_autosomal_infinite_alleles}
\alias{population_populate_autosomal_infinite_alleles}
\title{Populate 1-locus autosomal DNA profile in pedigrees with infinite alleles mutation model.}
\usage{
population_populate_autosomal_infinite_alleles(
  population,
  mutation_rate,
  progress = TRUE
)
}
\arguments{
\item{population}{Population in which to populate genotypes}

\item{mutation_rate}{Mutation rate between 0 and 1 (both included)}

\item{progress}{Show progress}
}
\description{
Populate 1-locus autosomal DNA profile from founder and down in all pedigrees.
Note, that all founders have type 0 to begin with.
}
\details{
The maternal allele is taken by random from
the \code{2*N[g]} alleles in the previous generation consisting of \code{N[g]} males
with descendants in the live population.

This is also why this is not using pedigrees but instead the population.

Note, that pedigrees need not be inferred.
}
\seealso{
\code{\link[=pedigrees_all_populate_haplotypes_custom_founders]{pedigrees_all_populate_haplotypes_custom_founders()}} and
\code{\link[=pedigrees_all_populate_haplotypes_ladder_bounded]{pedigrees_all_populate_haplotypes_ladder_bounded()}}.
}
