% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_posterior_diagnostics.R
\name{plot_several_posterior_stan}
\alias{plot_several_posterior_stan}
\title{Plotting several posterior distributions}
\usage{
plot_several_posterior_stan(
  objs,
  param = c("prior", "variance", "stdev", "precision", "logvariance")
)
}
\arguments{
\item{objs}{A names list with objects of class \code{mmp_stan} from \code{inference_stan}, can be any length
(but typically length two for one prior (\code{use_likelihood = FALSE}) and posterior, or two posteriors).}

\item{param}{A string indicating parameterization of plot.
\code{"prior"} for scale of parameters,
\code{"variance"}, \code{"stdev"}, \code{"precision"} and \code{"logvariance"} are also possible.}
}
\value{
A \link[ggplot2]{ggplot} with the posterior distributions.
}
\description{
Function for plotting the posterior distributions of the random effect variances
on the scale of the tree parameterization.
}
\details{
We cannot sample from a Jeffreys' prior since it is improper.
If Jeffreys' prior is used for the total variance, the prior will be changed to a Gaussian(0,1) prior on
the log total variance. This means that it does not make sense to look at the variances/standard deviations/precisions,
but the variance proportions will be correct.
See also \link[makemyprior]{makemyprior_plotting}.
}
\examples{
\dontrun{

ex_prior <- makemyprior_example_model()
res_stan <- inference_stan(ex_prior)
extract_posterior_variance(res_stan, "a")
}

}
\keyword{plot}
