% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03-dataset_functions.R
\name{dataset_cat_as_labels}
\alias{dataset_cat_as_labels}
\title{Apply data dictionary category labels to the associated dataset variables}
\usage{
dataset_cat_as_labels(dataset, data_dict = NULL, col_names = names(dataset))
}
\arguments{
\item{dataset}{A dataset object.}

\item{data_dict}{A list of data frame(s) representing metadata of the input
dataset. Automatically generated if not provided.}

\item{col_names}{A character string specifying the name(s) of the column(s)
which refer to existing column(s) in the dataset. The column(s) can be named
or indicated by position.}
}
\value{
A data frame identifying a dataset.
}
\description{
Applies category labels declared in a data dictionary to the associated
columns (variables) in the dataset.
}
\details{
A dataset is a data table containing variables. A dataset object is a
data frame and can be associated with a data dictionary. If no
data dictionary is provided with a dataset, a minimum workable
data dictionary will be generated as needed within relevant functions.
Identifier variable(s) for indexing can be specified by the user.
The id values must be non-missing and will be used in functions that
require it. If no identifier variable is specified, indexing is
handled automatically by the function.

A data dictionary contains the list of variables in a dataset and metadata
about the variables and can be associated with a dataset. A data dictionary
object is a list of data frame(s) named 'Variables' (required) and
'Categories' (if any). To be usable in any function, the data frame
'Variables' must contain at least the \code{name} column, with all unique and
non-missing entries, and the data frame 'Categories' must contain at least
the \code{variable} and \code{name} columns, with unique combination of
\code{variable} and \code{name}.
}
\examples{
{

dataset = madshapR_DEMO$dataset_PARIS
data_dict = as_data_dict_mlstr(madshapR_DEMO$data_dict_PARIS)
dataset_cat_as_labels(dataset, data_dict, col_names = 'SEX')

}

}
