% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{riskDiffExactPValue}
\alias{riskDiffExactPValue}
\title{P-value for exact unconditional test of risk difference}
\usage{
riskDiffExactPValue(
  riskDiffH0 = 0,
  directionUpper = 1L,
  n1 = NA_integer_,
  y1 = NA_integer_,
  n2 = NA_integer_,
  y2 = NA_integer_
)
}
\arguments{
\item{riskDiffH0}{The risk difference under the null hypothesis.
Defaults to 0.}

\item{directionUpper}{Whether larger values represent better
responses.}

\item{n1}{The sample size for the active treatment group.}

\item{y1}{The number of responses for the active treatment group.}

\item{n2}{The sample size for the control group.}

\item{y2}{The number of responses for the control group.}
}
\value{
A data frame containing the following variables:
\itemize{
\item \code{riskDiffH0}: The risk difference under the null hypothesis.
\item \code{directionUpper}: Whether larger values represent better
responses.
\item \code{riskDiff}: The observed risk difference.
\item \code{zstat}: The observed value of the Z test statistic.
\item \code{pvalue}: The one-sided p-value for the unconditional exact test.
\item \code{pi2star}: The value of pi2 that yields the p-value.
}
}
\description{
Obtains the p-value for exact unconditional
test of risk difference.
}
\examples{

riskDiffExactPValue(riskDiffH0 = 0, directionUpper = 1,
                    n1 = 68, y1 = 2, n2 = 65, y2 = 1)

}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
