% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getDesignProportions.R
\name{BOINTable}
\alias{BOINTable}
\title{BOIN decision table}
\usage{
BOINTable(
  nMax = NA_integer_,
  pT = 0.3,
  phi1 = 0.6 * pT,
  phi2 = 1.4 * pT,
  a = 1,
  b = 1,
  pExcessTox = 0.95
)
}
\arguments{
\item{nMax}{The maximum number of subjects in a dose cohort.}

\item{pT}{The target toxicity probability. Defaults to 0.3.}

\item{phi1}{The lower equivalence limit for target toxicity
probability.}

\item{phi2}{The upper equivalence limit for target toxicity
probability.}

\item{a}{The prior toxicity parameter for the beta prior.}

\item{b}{The prior non-toxicity parameter for the beta prior.}

\item{pExcessTox}{The threshold for excessive toxicity, i.e.,
if Prob(p > pT | Data) > pExcessTox, then the current and
all higher doses will be excluded and never be used again
in the remainder of the trial to avoid any other subjects
receiving treatment at those doses. Defaults to 0.95.}
}
\value{
An S3 class \code{BOINTable} object with the following
components:
\itemize{
\item \code{settings}: The input settings data frame with the following
variables:
\itemize{
\item \code{nMax}: The maximum number of subjects in a dose cohort.
\item \code{pT}: The target toxicity probability.
\item \code{phi1}: The lower equivalence limit for target toxicity
probability.
\item \code{phi2}: The upper equivalence limit for target toxicity
probability.
\item \code{lambda1}: The lower decision boundary for observed toxicity
probability.
\item \code{lambda2}: The upper decision boundary for observed toxicity
probability.
\item \code{a}: The prior toxicity parameter for the beta prior.
\item \code{b}: The prior non-toxicity parameter for the beta prior.
\item \code{pExcessTox}: The threshold for excessive toxicity.
}
\item \code{decisionDataFrame}: The decision data frame for the BOIN design.
It includes the following variables:
\itemize{
\item \code{n}: The sample size.
\item \code{y}: The number of toxicities.
\item \code{decision}: The dosing decision.
}
\item \code{decisionMatrix}: The decision matrix corresponding to the
decision data frame.
}
}
\description{
Obtains the decision table for the Bayesian optimal
interval (BOIN) design.
}
\examples{

BOINTable(nMax = 18, pT = 0.3, phi = 0.6*0.3, phi2 = 1.4*0.3)

}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
