% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{getDurationFromNevents}
\alias{getDurationFromNevents}
\title{Range of accrual duration for target number of events}
\usage{
getDurationFromNevents(
  nevents = NA_real_,
  allocationRatioPlanned = 1,
  accrualTime = 0L,
  accrualIntensity = NA_real_,
  piecewiseSurvivalTime = 0L,
  stratumFraction = 1L,
  lambda1 = NA_real_,
  lambda2 = NA_real_,
  gamma1 = 0L,
  gamma2 = 0L,
  followupTime = 18,
  fixedFollowup = 0L,
  npoints = 23L,
  interval = as.numeric(c(0.001, 240))
)
}
\arguments{
\item{nevents}{The target number of events.}

\item{allocationRatioPlanned}{Allocation ratio for the active treatment
versus control. Defaults to 1 for equal randomization.}

\item{accrualTime}{A vector that specifies the starting time of
piecewise Poisson enrollment time intervals. Must start with 0, e.g.,
\code{c(0, 3)} breaks the time axis into 2 accrual intervals:
[0, 3) and [3, Inf).}

\item{accrualIntensity}{A vector of accrual intensities. One for
each accrual time interval.}

\item{piecewiseSurvivalTime}{A vector that specifies the starting time of
piecewise exponential survival time intervals. Must start with 0, e.g.,
\code{c(0, 6)} breaks the time axis into 2 event intervals:
[0, 6) and [6, Inf).
Defaults to 0 for exponential distribution.}

\item{stratumFraction}{A vector of stratum fractions that sum to 1.
Defaults to 1 for no stratification.}

\item{lambda1}{A vector of hazard rates for the event in each analysis
time interval by stratum for the active treatment group.}

\item{lambda2}{A vector of hazard rates for the event in each analysis
time interval by stratum for the control group.}

\item{gamma1}{The hazard rate for exponential dropout, a vector of hazard
rates for piecewise exponential dropout applicable for all strata, or a
vector of hazard rates for dropout in each analysis time interval
by stratum for the active treatment group.}

\item{gamma2}{The hazard rate for exponential dropout, a vector of hazard
rates for piecewise exponential dropout applicable for all strata, or a
vector of hazard rates for dropout in each analysis time interval
by stratum for the control group.}

\item{followupTime}{Follow-up time for the last enrolled subject.}

\item{fixedFollowup}{Whether a fixed follow-up design is used.
Defaults to 0 for variable follow-up.}

\item{npoints}{The number of accrual duration time points.
Defaults to 23.}

\item{interval}{The interval to search for the solution of
accrualDuration. Defaults to \code{c(0.001, 240)}.}
}
\value{
A data frame of the following variables:
\itemize{
\item \code{nevents}: The target number of events.
\item \code{fixedFollowup}: Whether a fixed follow-up design is used.
\item \code{accrualDuration}: The accrual duration.
\item \code{subjects}: The total number of subjects.
\item \code{studyDuration}: The study duration.
}
}
\description{
Obtains a range of accrual duration to reach the
target number of events.
}
\examples{
# Piecewise accrual, piecewise exponential survivals, and 5\% dropout by
# the end of 1 year.

getDurationFromNevents(
  nevents = 80, allocationRatioPlanned = 1,
  accrualTime = seq(0, 8),
  accrualIntensity = 26/9*seq(1, 9),
  piecewiseSurvivalTime = c(0, 6),
  stratumFraction = c(0.2, 0.8),
  lambda1 = c(0.0533, 0.0309, 1.5*0.0533, 1.5*0.0309),
  lambda2 = c(0.0533, 0.0533, 1.5*0.0533, 1.5*0.0533),
  gamma1 = -log(1-0.05)/12,
  gamma2 = -log(1-0.05)/12,
  fixedFollowup = FALSE)

}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
