% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{remlRateRatio}
\alias{remlRateRatio}
\title{REML Estimates of Individual Rates With Specified Rate Ratio}
\usage{
remlRateRatio(
  rateRatioH0 = 1,
  t1 = NA_real_,
  y1 = NA_real_,
  t2 = NA_real_,
  y2 = NA_real_
)
}
\arguments{
\item{rateRatioH0}{The specified rate ratio.}

\item{t1}{The exposure for the active treatment group.}

\item{y1}{The number of events for the active treatment group.}

\item{t2}{The exposure for the control group.}

\item{y2}{The number of events for the control group.}
}
\value{
A vector of the restricted maximum likelihood estimates
of the incidence rates for the two treatment groups.
}
\description{
Obtains the restricted maximum likelihood estimates of
individual proportions with specified rate ratio.
}
\examples{

remlRateRatio(rateRatioH0 = 1.1, t1 = 10, y1 = 4, t2 = 20, y2 = 2)

}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
