% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{getCP}
\alias{getCP}
\title{Conditional power allowing for varying parameter values}
\usage{
getCP(
  INew = NA_real_,
  L = NA_integer_,
  zL = NA_real_,
  theta = NA_real_,
  IMax = NA_real_,
  kMax = NA_integer_,
  informationRates = NA_real_,
  efficacyStopping = NA_integer_,
  futilityStopping = NA_integer_,
  criticalValues = NA_real_,
  alpha = 0.025,
  typeAlphaSpending = "sfOF",
  parameterAlphaSpending = NA_real_,
  userAlphaSpending = NA_real_,
  futilityBounds = NA_real_,
  typeBetaSpending = "none",
  parameterBetaSpending = NA_real_,
  spendingTime = NA_real_,
  MullerSchafer = 0L,
  kNew = NA_integer_,
  informationRatesNew = NA_real_,
  efficacyStoppingNew = NA_integer_,
  futilityStoppingNew = NA_integer_,
  typeAlphaSpendingNew = "sfOF",
  parameterAlphaSpendingNew = NA_real_,
  typeBetaSpendingNew = "none",
  parameterBetaSpendingNew = NA_real_,
  spendingTimeNew = NA_real_
)
}
\arguments{
\item{INew}{The maximum information of the secondary trial.}

\item{L}{The interim adaptation look of the primary trial.}

\item{zL}{The z-test statistic at the interim adaptation look of
the primary trial.}

\item{theta}{A scalar or a vector of parameter values of
length \code{kMax + kMax - L} if \code{MullerSchafer = FALSE} or
length \code{kMax + kNew} if \code{MullerSchafer = TRUE}.}

\item{IMax}{The maximum information of the primary trial.}

\item{kMax}{The maximum number of stages of the primary trial.}

\item{informationRates}{The information rates of the primary trial.}

\item{efficacyStopping}{Indicators of whether efficacy stopping is
allowed at each stage of the primary trial. Defaults to true
if left unspecified.}

\item{futilityStopping}{Indicators of whether futility stopping is
allowed at each stage of the primary trial. Defaults to true
if left unspecified.}

\item{criticalValues}{The upper boundaries on the z-test statistic scale
for efficacy stopping for the primary trial.}

\item{alpha}{The significance level of the primary trial.
Defaults to 0.025.}

\item{typeAlphaSpending}{The type of alpha spending for the primary
trial. One of the following:
"OF" for O'Brien-Fleming boundaries,
"P" for Pocock boundaries,
"WT" for Wang & Tsiatis boundaries,
"sfOF" for O'Brien-Fleming type spending function,
"sfP" for Pocock type spending function,
"sfKD" for Kim & DeMets spending function,
"sfHSD" for Hwang, Shi & DeCani spending function,
"user" for user defined spending, and
"none" for no early efficacy stopping.
Defaults to "sfOF".}

\item{parameterAlphaSpending}{The parameter value of alpha spending
for the primary trial. Corresponds to Delta for "WT", rho for "sfKD",
and gamma for "sfHSD".}

\item{userAlphaSpending}{The user defined alpha spending for the primary
trial. Cumulative alpha spent up to each stage.}

\item{futilityBounds}{The lower boundaries on the z-test statistic scale
for futility stopping for the primary trial. Defaults to
\code{rep(-6, kMax-1)} if left unspecified.}

\item{typeBetaSpending}{The type of beta spending for the primary trial.
One of the following:
"sfOF" for O'Brien-Fleming type spending function,
"sfP" for Pocock type spending function,
"sfKD" for Kim & DeMets spending function,
"sfHSD" for Hwang, Shi & DeCani spending function, and
"none" for no early futility stopping.
Defaults to "none".}

\item{parameterBetaSpending}{The parameter value of beta spending
for the primary trial. Corresponds to rho for "sfKD",
and gamma for "sfHSD".}

\item{spendingTime}{The error spending time of the primary trial.
Defaults to missing, in which case, it is the same as
\code{informationRates}.}

\item{MullerSchafer}{Whether to use the Muller and Schafer (2001) method
for trial adaptation.}

\item{kNew}{The number of looks of the secondary trial.}

\item{informationRatesNew}{The spacing of looks of the secondary trial.}

\item{efficacyStoppingNew}{The indicators of whether efficacy stopping is
allowed at each look of the secondary trial. Defaults to true
if left unspecified.}

\item{futilityStoppingNew}{The indicators of whether futility stopping is
allowed at each look of the secondary trial. Defaults to true
if left unspecified.}

\item{typeAlphaSpendingNew}{The type of alpha spending for the secondary
trial. One of the following:
"OF" for O'Brien-Fleming boundaries,
"P" for Pocock boundaries,
"WT" for Wang & Tsiatis boundaries,
"sfOF" for O'Brien-Fleming type spending function,
"sfP" for Pocock type spending function,
"sfKD" for Kim & DeMets spending function,
"sfHSD" for Hwang, Shi & DeCani spending function, and
"none" for no early efficacy stopping.
Defaults to "sfOF".}

\item{parameterAlphaSpendingNew}{The parameter value of alpha spending
for the secondary trial. Corresponds to Delta for "WT", rho for "sfKD",
and gamma for "sfHSD".}

\item{typeBetaSpendingNew}{The type of beta spending for the secondary
trial. One of the following:
"sfOF" for O'Brien-Fleming type spending function,
"sfP" for Pocock type spending function,
"sfKD" for Kim & DeMets spending function,
"sfHSD" for Hwang, Shi & DeCani spending function, and
"none" for no early futility stopping.
Defaults to "none".}

\item{parameterBetaSpendingNew}{The parameter value of beta spending
for the secondary trial. Corresponds to rho for "sfKD",
and gamma for "sfHSD".}

\item{spendingTimeNew}{The error spending time of the secondary trial.
Defaults to missing, in which case, it is the same as
\code{informationRatesNew}.}
}
\value{
The conditional power given the interim results, parameter
values, and data-dependent design changes.
}
\description{
Obtains the conditional power for specified incremental
information given the interim results, parameter values, and
data-dependent changes in the error spending function and the
number and spacing of interim looks.
}
\examples{

# Conditional power calculation with delayed treatment effect

# Two interim analyses have occurred with 179 and 266 events, respectively
# The observed hazard ratio at the second interim look is 0.81

trialsdt = as.Date("2020-03-04")                       # trial start date
iadt = c(as.Date("2022-02-01"), as.Date("2022-11-01")) # interim dates
mo1 = as.numeric(iadt - trialsdt + 1)/30.4375          # interim months

# Assume a piecewise Poisson enrollment process with a 8-month ramp-up and
# 521 patients were enrolled after 17.94 months
N = 521                   # total number of patients
Ta = 17.94                # enrollment duration
Ta1 = 8                   # assumed end of enrollment ramp-up
enrate = N / (Ta - Ta1/2) # enrollment rate after ramp-up

# Assume a median survival of 16.7 months for the control group, a 5-month
# delay in treatment effect, and a hazard ratio of 0.7 after the delay
lam1 = log(2)/16.7  # control group hazard of exponential distribution
t1 = 5              # months of delay in treatment effect
hr = 0.7            # hazard ratio after delay
lam2 = hr*lam1      # treatment group hazard after delay

# Assume an annual dropout rate of 5\%
gam = -log(1-0.05)/12  # hazard for dropout

# The original target number of events was 298 and the new target is 335
mo2 <- caltime(
  nevents = c(298, 335),
  allocationRatioPlanned = 1,
  accrualTime = seq(0, Ta1), 
  accrualIntensity = enrate*seq(1, Ta1+1)/(Ta1+1),
  piecewiseSurvivalTime = c(0, t1),
  lambda1 = c(lam1, lam2),
  lambda2 = c(lam1, lam1),
  gamma1 = gam,
  gamma2 = gam,
  accrualDuration = Ta,
  followupTime = 1000)

# expected number of events and average hazard ratios
(lr1 <- lrstat(
  time = c(mo1, mo2),
  accrualTime = seq(0, Ta1), 
  accrualIntensity = enrate*seq(1, Ta1+1)/(Ta1+1),
  piecewiseSurvivalTime = c(0, t1),
  lambda1 = c(lam1, lam2),
  lambda2 = c(lam1, lam1),
  gamma1 = gam,
  gamma2 = gam,
  accrualDuration = Ta,
  followupTime = 1000,
  predictTarget = 3))


hr2 = 0.81                    # observed hazard ratio at interim 2
z2 = (-log(hr2))*sqrt(266/4)  # corresponding z-test statistic value
 
# expected mean of -log(HR) at the original looks and the new final look
theta = -log(lr1$HR[c(1,2,3,4)])

# conditional power with sample size increase
getCP(INew = (335 - 266)/4, 
      L = 2, zL = z2, theta = theta,
      IMax = 298/4, kMax = 3, 
      informationRates = c(179, 266, 298)/298,
      alpha = 0.025, typeAlphaSpending = "sfOF")

}
\references{
Cyrus R. Mehta and Stuart J. Pocock.
Adaptive increase in sample size when interim results are promising:
A practical guide with examples.
Stat Med. 2011;30:3267–3284.
}
\seealso{
\code{\link{getDesign}}
}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
