% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphutils.R
\name{ndtransitiongraph}
\alias{ndtransitiongraph}
\title{Create a n-d transition graph}
\usage{
ndtransitiongraph(nodes, n, separator = ":")
}
\arguments{
\item{nodes}{node names of graph}

\item{n}{integer, dimension an edge should represent}

\item{separator}{character that separates spaces in node names}
}
\value{
graph object of class loongraph
}
\description{
A n-d transition graph has k-d nodes and all edges that connect
  two nodes that from a n-d subspace
}
\details{
For more information run: \code{l_help("learn_R_display_graph.html.html#graph-utilities")}
}
\examples{
g <- ndtransitiongraph(nodes=c('A:B', 'A:F', 'B:C', 'B:F'), n=3, separator=':')
}
