% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/northrop.R
\name{nc_score_test}
\alias{nc_score_test}
\title{Score test of Northrop and Coleman}
\usage{
nc_score_test(
  time,
  time2 = NULL,
  event = NULL,
  thresh = 0,
  ltrunc = NULL,
  rtrunc = NULL,
  type = c("right", "left", "interval", "interval2"),
  weights = rep(1, length(time))
)
}
\arguments{
\item{time}{excess time of the event of follow-up time, depending on the value of event}

\item{time2}{ending excess time of the interval for interval censored data only.}

\item{event}{status indicator, normally 0=alive, 1=dead. Other choices are \code{TRUE}/\code{FALSE} (\code{TRUE} for death).
For interval censored data, the status indicator is 0=right censored, 1=event at time, 2=left censored, 3=interval censored.
Although unusual, the event indicator can be omitted, in which case all subjects are assumed to have experienced an event.}

\item{thresh}{a vector of thresholds}

\item{ltrunc}{lower truncation limit, default to \code{NULL}}

\item{rtrunc}{upper truncation limit, default to \code{NULL}}

\item{type}{character string specifying the type of censoring. Possible values are "\code{right}", "\code{left}", "\code{interval}", "\code{interval2}".}

\item{weights}{weights for observations}
}
\value{
the value of a call to \code{nc_test}
}
\description{
This function computes the score test
with the piecewise generalized Pareto distribution
under the null hypothesis that the generalized Pareto
with a single shape parameter is an adequate simplification.
The score test statistic is calculated using the observed information
matrix; both hessian and score vector are obtained through numerical differentiation.
}
\details{
The score test is much faster and perhaps less fragile than the likelihood ratio test:
fitting the piece-wise generalized Pareto model is difficult due to the large number of
parameters and multimodal likelihood surface.

The reference distribution is chi-square
}
\examples{
\donttest{
set.seed(1234)
n <- 100L
x <- samp_elife(n = n,
                scale = 2,
                shape = -0.2,
                lower = low <- runif(n),
                upper = upp <- runif(n, min = 3, max = 20),
                type2 = "ltrt",
                family = "gp")
test <- nc_test(
  time = x,
  ltrunc = low,
  rtrunc = upp,
  thresh = quantile(x, seq(0, 0.5, by = 0.1)))
print(test)
plot(test)
}
}
\keyword{internal}
