% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package-support.R
\name{LMK_bscale}
\alias{LMK_bscale}
\title{Backscale an array}
\usage{
LMK_bscale(A, cs)
}
\arguments{
\item{A}{A 3D landmark array}

\item{cs}{a vector of centroid sizes}
}
\value{
Returns a scaled 3D landmark array
}
\description{
Scale each individual of a landmark array by an arbitrary value (e.g. centroid size)
}
\examples{

require(geomorph)
data(plethodon)

plotAllSpecimens(plethodon$land) ## plot all unaligned specimens
gpa <- gpagen(plethodon$land) ## align AND SCALE data
plotAllSpecimens(gpa$coords)

backscaled <- LMK_bscale(gpa$coords, gpa$Csize)

plotAllSpecimens(backscaled) ## data are aligned, but in their original size

}
