% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastmbu.R
\name{fastmbu}
\alias{fastmbu}
\title{Fast version of mbu. It runs mbu without input checks.}
\usage{
fastmbu(
  Y = NULL,
  W = NULL,
  XU = NULL,
  BU = NULL,
  XV = NULL,
  BV = NULL,
  mains = TRUE,
  MAXITER = 65536,
  DCRIT = 1e-06,
  MAXINNER = 32,
  FCRIT = 0.001
)
}
\arguments{
\item{Y}{matrix with dichotomous responses}

\item{W}{matrix with weights for each entrance of Y or vector with weights for each row of Y}

\item{XU}{in unsupervised analysis starting values for row coordinates; in supervised analysis matrix with predictor variables for rows}

\item{BU}{for supervised analysis matrix with regression weights for the row coordinates}

\item{XV}{in unsupervised analysis starting values for column coordinates; in supervised analysis matrix with predictor variables for columns}

\item{BV}{for supervised analysis matrix with regression weights for the column coordinates}

\item{mains}{whether offsets for the items should be estimated}

\item{MAXITER}{maximum number of iterations in the outer loop}

\item{DCRIT}{convergence criterion for the deviance}

\item{MAXINNER}{maximum number of iterations in the inner loop}

\item{FCRIT}{convergence criterion for STRESS in the inner loop}
}
\value{
U estimated coordinate matrix for row objects

BU for supervised analysis the estimated matrix with regression weights for the rows

V estimated coordinate matrix for column objects

BV for supervised analysis the estimated matrix with regression weights for the columns

Mu estimated offsets

Lastinner number of iterations in the last call to STRESS

Lastfdif last difference in STRESS values in the inner loop

lastouter  number of iterations in the outer loop

lastddif last difference in deviances in outer loop

deviance obtained deviance
}
\description{
Fast version of mbu. It runs mbu without input checks.
}
