% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/which_best.R
\name{which_best}
\alias{which_best}
\title{Determine which individual has smallest distance to each individual}
\usage{
which_best(d, dimension = c("row", "column"), get_min = TRUE)
}
\arguments{
\item{d}{A distance matrix}

\item{dimension}{Whether to get the minimum by row or by column}

\item{get_min}{If TRUE, get the minimum; if FALSE, get the maximum}
}
\value{
A vector with \strong{all} distinct individuals, with the
character string labels for the individuals giving the minimum
(or maximum) value by row or column. We include all individuals
so that the results are aligned with the results of
\code{\link[=get_self]{get_self()}}.
}
\description{
For each individual represented in a distance matrix, find the
individual giving the smallest entry (with NAs for individuals
present in only the rows or only the columns).
}
\examples{
# align rows in the provided dataset, lineup2ex
aligned <- align_matrix_rows(lineup2ex$gastroc, lineup2ex$islet)
# find correlated columns
selected_genes <- (corr_betw_matrices(aligned[[1]], aligned[[2]], "paired") > 0.75)
# calculate correlation between rows
similarity <- corr_betw_matrices(t(lineup2ex$gastroc[,selected_genes]),
                                 t(lineup2ex$islet[,selected_genes]), "all")
# which sample gives maximum value by row
best_byrow <- which_best(similarity, get_min=FALSE)

# which sample gives maximum value by column
best_bycol <- which_best(similarity, get_min=FALSE, dimension="column")

}
\seealso{
\code{\link[=get_best]{get_best()}}, \code{\link[=get_self]{get_self()}}, \code{\link[=get_2ndbest]{get_2ndbest()}}, \code{\link[=which_2ndbest]{which_2ndbest()}}
}
