% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hist_self_nonself.R
\name{hist_self_nonself}
\alias{hist_self_nonself}
\title{Plot histograms of self-self and self-nonself distances}
\usage{
hist_self_nonself(d, breaks = NULL, rug = TRUE, xlabel = "distance")
}
\arguments{
\item{d}{A distance matrix}

\item{breaks}{Histogram breaks (default is to use 100 intervals)}

\item{rug}{If TRUE, use \code{\link[graphics:rug]{graphics::rug()}} to plot tick marks at the
observed values, below the histograms.}

\item{xlabel}{Label on x-axes (e.g., "similarity" vs "distance")}
}
\value{
None.
}
\description{
Plot histograms of self-self and self-nonself distances
}
\details{
We use the \code{mfrow} arg for \code{\link[graphics:par]{graphics::par()}} to make a
two-panel figure.
}
\examples{
# align rows in the provided dataset, lineup2ex
aligned <- align_matrix_rows(lineup2ex$gastroc, lineup2ex$islet)
# find correlated columns
selected_genes <- (corr_betw_matrices(aligned[[1]], aligned[[2]], "paired") > 0.75)
# calculate correlation between rows
similarity <- corr_betw_matrices(t(lineup2ex$gastroc[,selected_genes]),
                                 t(lineup2ex$islet[,selected_genes]), "all")
# histograms of the self and non-self distances
hist_self_nonself(similarity)

}
\seealso{
\code{\link[=get_self]{get_self()}}, \code{\link[=get_nonself]{get_nonself()}}
}
