% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_betw_matrices.R
\name{dist_betw_matrices}
\alias{dist_betw_matrices}
\title{Distance between rows of two matrices}
\usage{
dist_betw_matrices(
  x,
  y,
  distance = c("rmsd", "mad"),
  align_cols = TRUE,
  cores = 1
)
}
\arguments{
\item{x}{A numeric matrix.}

\item{y}{A second numeric matrix, with the same number of columns as \code{x}.}

\item{distance}{Indicates whether to use Euclidean distance
(\code{"rmsd"} for root mean square difference) or the mean absolute
difference (\code{"mad"}).}

\item{align_cols}{If TRUE, align the columns in the two matrices by
the column names.}

\item{cores}{Number of CPU cores to use, for parallel calculations.
(If \code{0}, use \code{\link[parallel:detectCores]{parallel::detectCores()}}.)
Alternatively, this can be links to a set of cluster sockets, as
produced by \code{\link[parallel:makeCluster]{parallel::makeCluster()}}.}
}
\value{
If \code{x} is \code{m} by \code{p} and \code{y} is \code{n} by \code{p}, then the result
is an \code{m} by \code{n} matrix whose (i,j)th element is the distance
between the ith row of \code{x} and the jth row of \code{y}.
}
\description{
Calculate the distances between the rows of one matrix and the rows
of a second matrix.
}
\examples{
p <- 10
n <- 5
m <- 3
x <- matrix(stats::rnorm(n*p), ncol=p)
rownames(x) <- LETTERS[1:n]
y <- matrix(stats::rnorm(m*p), ncol=p)
rownames(y) <- letters[1:m]

d <- dist_betw_matrices(x, y)

}
\seealso{
\code{\link[=corr_betw_matrices]{corr_betw_matrices()}}, \code{\link[=dist_betw_arrays]{dist_betw_arrays()}}
}
