% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot2dist.R
\name{plot2dist}
\alias{plot2dist}
\title{Plot two sets of inter-individual distances against one another}
\usage{
plot2dist(
  d1,
  d2,
  hirow = NULL,
  hicol = NULL,
  xlab = NULL,
  ylab = NULL,
  smoothScatter = FALSE,
  colself = "black",
  colnonself = "gray",
  colhirow = "green",
  colhicol = "orange",
  ...
)
}
\arguments{
\item{d1}{Output of \code{\link[=distee]{distee()}}.}

\item{d2}{Output of \code{\link[=distee]{distee()}}.}

\item{hirow}{Names of rows to highlight in green.}

\item{hicol}{Names of columns to highlight in orange.}

\item{xlab}{X-axis label (optional)}

\item{ylab}{Y-axis label (optional)}

\item{smoothScatter}{If TRUE, plot non-self distances with
\code{\link[graphics:smoothScatter]{graphics::smoothScatter()}}; if FALSE, use \code{base::plot()}.}

\item{colself}{Color to use for the self-self points.  If NULL, these aren't
plotted.}

\item{colnonself}{Color to use for the non-self points.  If NULL, these
aren't plotted.}

\item{colhirow}{Color to use for the \code{hirow} points.  If NULL, these
aren't plotted.}

\item{colhicol}{Color to use for the \code{hicol} points.  If NULL, these
aren't plotted.}

\item{\dots}{Passed to \code{base::plot()} and
\code{\link[graphics:points]{graphics::points()}}.}
}
\value{
None.
}
\description{
Plot two sets of inter-individual distances against one another, colored by
self and non-self distances.
}
\examples{
data(expr1, expr2)

\dontshow{expr1 <- expr1[,1:500]
expr2 <- expr2[,1:500]}

# distances as RMS difference and correlation
d_rmsd <- distee(expr1, expr2, "rmsd")
d_cor <- distee(expr1, expr2, "cor")

# plot distances against one another
plot2dist(d_rmsd, d_cor)

}
\seealso{
\code{\link[=pulldiag]{pulldiag()}}, \code{\link[=distee]{distee()}},
\code{\link[=summary.lineupdist]{summary.lineupdist()}}
}
\author{
Karl W Broman, \email{broman@wisc.edu}
}
\keyword{graphics}
