% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/summary.lineupdist.R
\name{summary.lineupdist}
\alias{summary.lineupdist}
\title{Summarize inter-individual distances}
\usage{
\method{summary}{lineupdist}(object, cutoff, dropmatches = TRUE,
  reorder = c("alignmatches", "bydistance", "no"), ...)
}
\arguments{
\item{object}{Output of \code{\link{distee}} or \code{\link{disteg}}.}

\item{cutoff}{(Optional) Cutoff on correlation/distance, with rows in the
results only being kept if the best distance/correlation is above this
cutoff or the self-self result is not missing and is above this cutoff.}

\item{dropmatches}{If TRUE, omit rows for which an individual's best match
is itself.}

\item{reorder}{If \code{"bydistance"}, reorder rows by increasing distance
(or decreasing correlation) to the best match and then by decreasing
distance (or decreasing correlation) to self; if \code{"alignmatches"},
group related errors together; if \code{"no"}, leave as is.}

\item{\dots}{Passed to \code{\link[base]{print.data.frame}}.}
}
\value{
A list with two components: the distances summarized by row and the
distances summarized by column.

For each individual, we calculate the minimum distance to others,
next-smallest distance, the self-self distance, the mean and SD of the
distances to others, and finally indicate the individual (or individuals)
that is closest.
}
\description{
Summarize the results of \code{\link{distee}} or \code{\link{disteg}}, with
inter-individual distances between two sets of gene expression data.
}
\examples{
data(expr1, expr2)

\dontshow{expr1 <- expr1[,1:500]
expr2 <- expr2[,1:500]}

# distance as correlation
d <- distee(expr1, expr2, "cor")

# summary of potential problems
summary(d)
}
\author{
Karl W Broman, \email{kbroman@biostat.wisc.edu}
}
\seealso{
\code{\link{pulldiag}}, \code{\link{omitdiag}},
\code{\link{distee}}, \code{\link{disteg}}, \code{\link{plot2dist}},
\code{\link{plot.lineupdist}}
}
\keyword{utilities}

