% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tour-app.R
\name{limn_tour}
\alias{limn_tour}
\title{Tour a high dimensional dataset}
\usage{
limn_tour(
  tour_data,
  cols,
  color = NULL,
  tour_path = tourr::grand_tour(),
  rescale = clamp,
  morph = "center",
  gadget_mode = TRUE
)
}
\arguments{
\item{tour_data}{a data.frame to tour}

\item{cols}{Columns to tour. This can use a tidyselect specification
such as \code{\link[tidyselect:starts_with]{tidyselect::starts_with()}}.}

\item{color}{A variable mapping to the color aesthetic, if
NULL points will be colored black.}

\item{tour_path}{the tour path to take, the default is \code{\link[tourr:grand_tour]{tourr::grand_tour()}}
but also works with \code{\link[tourr:guided_tour]{tourr::guided_tour()}}.}

\item{rescale}{A function that rescales \code{cols}, the default is to
\code{\link[=clamp]{clamp()}} the data to lie in the hyperdimensional unit cube. To not perform
any scaling use \code{\link[=identity]{identity()}}.}

\item{morph}{One of \code{c("center", "centre", "identity", "radial")}
that rescales each projection along the tour path. The default
is to center the projections and divide by half range. See \code{\link[=morph_center]{morph_center()}}
for details.}

\item{gadget_mode}{Run the app as a \code{\link[shiny:runGadget]{shiny::runGadget()}} which will load
the app in the RStudio Viewer pane or a browser (default = TRUE). If FALSE
will return a regular shiny app object that could be used to deploy the app
elsewhere.}
}
\value{
The tour interface loads a shiny app either in the Viewer pane
if you are using Rstudio or in a browser window. After iterating through
the tour and and highlighting subsets of interest, you can click the
'Done' button. This will return a named list with two elements:
\itemize{
\item \code{selected_basis}: a matrix consisting of the final projection selected
\item \code{tour_brush_box}: a list consisting of the bounding box of brush
\item \code{tour_half_range}: the current value of half range parameter
}
}
\description{
Tour a high dimensional dataset
}
\details{
The tour interface consists of two views:
\enumerate{
\item the tour view which is a dynamic scatterplot
\item the axis view which shows the direction and magnitude of the
basis vectors being generated.
}

There are several other user controls available:
\itemize{
\item A play button, that when pressed will start the tour animation.
\item A pause button, that when pressed will pause the tour animation.
\item The title of the view includes the half range. The half range
is a scale factor for projections and can be thought of as a way
of zooming in and out on points. It can be  modified by scrolling
(via a mouse-wheel movement). Double-click to reset to the default
tour view.
\item If categorical variable has been used, the legend can be toggled to
highlight categories of interest with shift + mouse click.
Multiple categories can be selected in this way. To reset double click
the legend title.
\item Brushing is activated by moving the mouse on the tour view.
If the tour animation a brush event will pause it.
}
}
\examples{
if (interactive()) {
  # tour the first ten columns of the fake tree data
  # loads the default interface
  limn_tour(fake_trees, dim1:dim10)
  # perform the same action but now coloring points
  limn_tour(fake_trees, dim1:dim10, color = branches)
}
}
\seealso{
\code{\link[=compute_half_range]{compute_half_range()}}, \code{\link[=morph_center]{morph_center()}}, \code{\link[=limn_tour_link]{limn_tour_link()}}
}
