% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connected_components.R
\name{knn_distance}
\alias{knn_distance}
\title{Computes the Distance to k-Nearest Neighbors}
\usage{
knn_distance(las, k = 10, name = "distance")
}
\arguments{
\item{las}{A LAS object representing the point cloud data.}

\item{k}{The number of nearest neighbors.}

\item{name}{A string specifying the name of the new attribute used to store the computed distances.}
}
\value{
A LAS object with an additional attribute named as specified by `name`.
}
\description{
Computes the average distance between each point and its k-nearest neighbors in a point cloud.
The results are stored in a new attribute.
}
\examples{
LASfile <- system.file("extdata", "MixedConifer.laz", package="lidR")
las <- readLAS(LASfile, select = "xyz", filter = "-inside 481250 3812980 481300 3813030")
las = knn_distance(las)
#plot(las, color = "distance", breaks = "quantile", legend = TRUE)
}
