/* libsoc - Library to handle standardised output files
 * Copyright (C) 2015 Rikard Nordgren
 * 
 * This file was autogenerated and should not be edited
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 * 
 * his library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, see <http://www.gnu.org/licenses/>.
 */
#ifndef _SO_TOOLSETTINGS_H
#define _SO_TOOLSETTINGS_H

#include <so/ExternalFile.h>

/** \struct so_ToolSettings
	 \brief A structure representing an SO/SOBlock/ToolSettings element
*/
typedef struct so_ToolSettings so_ToolSettings;

/** \memberof so_ToolSettings
 * Create a new empty so_ToolSettings structure.
 * \return A pointer to the newly created struct or NULL if memory allocation failed
 * \sa so_ToolSettings_copy, so_ToolSettings_free
 */
so_ToolSettings *so_ToolSettings_new();
/** \memberof so_ToolSettings
 * Create a copy of a so_ToolSettings structure.
 * \return A pointer to the newly created struct or NULL if memory allocation failed
 * \sa so_ToolSettings_new
 */
so_ToolSettings *so_ToolSettings_copy(so_ToolSettings *self);
/** \memberof so_ToolSettings
 * Free all memory associated with a so_ToolSettings structure and its children.
 * \param self - a pointer to the structure to free
 * \sa so_ToolSettings_new
 */
void so_ToolSettings_free(so_ToolSettings *self);
void so_ToolSettings_ref(so_ToolSettings *self);
void so_ToolSettings_unref(so_ToolSettings *self);
/** \memberof so_ToolSettings
 * Get the File element
 * \param self - pointer to a so_ToolSettings
 * \param number - An index to the specific element
 * \return A pointer to the structure representing the File element
 * \sa so_ToolSettings_set_File
 */
so_ExternalFile *so_ToolSettings_get_File(so_ToolSettings *self, int number);
/** \memberof so_ToolSettings
 * Get the number of File currently contained in the ToolSettings structure
 * \param self - pointer to a so_ToolSettings
 * \return The number of Files
 */
int so_ToolSettings_get_number_of_File(so_ToolSettings *self);
/** \memberof so_ToolSettings
 * Create a new File element and insert it into the so_ToolSettings
 * \param self - pointer to a so_ToolSettings
 * \return A pointer to the newly created structure or NULL if memory allocation failed
 */
so_ExternalFile *so_ToolSettings_create_File(so_ToolSettings *self);
int so_ToolSettings_add_File(so_ToolSettings *self, so_ExternalFile *child);
int so_ToolSettings_remove_File(so_ToolSettings *self, int index);

#endif
