/* libsoc - Library to handle standardised output files
 * Copyright (C) 2015 Rikard Nordgren
 * 
 * This file was autogenerated and should not be edited
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 * 
 * his library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, see <http://www.gnu.org/licenses/>.
 */
#include <string.h>
#include <libxml/xmlwriter.h>
#include <pharmml/common_types.h>
#include <pharmml/string.h>
#include <so/ToolSettings.h>
#include <so/private/ToolSettings.h>

so_ToolSettings *so_ToolSettings_new()
{
	so_ToolSettings *object = calloc(sizeof(so_ToolSettings), 1);
	if (object) {
		object->reference_count = 1;
	}

	return object;
}

so_ToolSettings *so_ToolSettings_copy(so_ToolSettings *self)
{
	so_ToolSettings *dest = so_ToolSettings_new();
	if (dest) {
		if (self->num_File) {
			dest->File = calloc(self->num_File * sizeof(so_ExternalFile *), 1);
			if (!dest->File) {
				so_ToolSettings_free(dest);
				return NULL;
			}
			dest->num_File = self->num_File;
			for (int i = 0; i < self->num_File; i++) {
				dest->File[i] = so_ExternalFile_copy(self->File[i]);
				if (!dest->File[i]) {
					so_ToolSettings_free(dest);
					return NULL;
				}
			}
		}
	}

	return dest;
}

void so_ToolSettings_free(so_ToolSettings *self)
{
	if (self) {
		for(int i = 0; i < self->num_File; i++) {
			so_ExternalFile_unref(self->File[i]);
		}
		free(self->File);
		free(self);
	}
}

void so_ToolSettings_ref(so_ToolSettings *self)
{
	self->reference_count++;
}

void so_ToolSettings_unref(so_ToolSettings *self)
{
	if (self) {
		self->reference_count--;
		if (!self->reference_count) {
			so_ToolSettings_free(self);
		}
	}
}

so_ExternalFile *so_ToolSettings_get_File(so_ToolSettings *self, int number)
{
	return self->File[number];
}

int so_ToolSettings_get_number_of_File(so_ToolSettings *self)
{
	return self->num_File;
}

so_ExternalFile *so_ToolSettings_create_File(so_ToolSettings *self)
{
	so_ExternalFile *obj = so_ExternalFile_new("File");
	if (obj) {
		so_ExternalFile **newblock = realloc(self->File, (self->num_File + 1) * sizeof(so_ExternalFile *));
		if (newblock) {
			self->File = newblock;
			self->File[self->num_File] = obj;
			self->num_File++;
		} else {
			so_ExternalFile_free(obj);
			obj = NULL;
		}
	}
	return obj;
}

int so_ToolSettings_add_File(so_ToolSettings *self, so_ExternalFile *child)
{
	so_ExternalFile **new_array = realloc(self->File, (self->num_File + 1) * sizeof(so_ExternalFile *));
	if (!new_array) {
		return 1;
	}
	self->File = new_array;
	self->File[self->num_File] = child;
	self->num_File++;
	return 0;
}

int so_ToolSettings_remove_File(so_ToolSettings *self, int index)
{
	int size = self->num_File;
	if (index >= size) {
		return 0;
	}
	if (size == 1) {
		free(self->File);
		self->File = NULL;
		return 0;
	}
	so_ExternalFile *final = self->File[size - 1];
	so_ExternalFile *remove = self->File[index];
	so_ExternalFile **new_array = realloc(self->File, (self->num_File - 1) * sizeof(so_ExternalFile *));
	if (!new_array) {
		return 1;
	}
	self->num_File--;
	if (final == remove) {
		return 0;
	}
	for (int i = index; i < size - 3; i++) {
		self->File[i] = self->File[i + 1];
	}
	self->File[size - 2] = final;
	so_ExternalFile_unref(remove);
	return 0;
}

int so_ToolSettings_xml(so_ToolSettings *self, xmlTextWriterPtr writer)
{
	int rc;
	if (self->File) {
		rc = xmlTextWriterStartElement(writer, BAD_CAST "ToolSettings");
		if (rc < 0) return 1;
		if (self->File) {
			for (int i = 0; i < self->num_File; i++) {
				rc = so_ExternalFile_xml(self->File[i], writer, "File");
				if (rc != 0) return 1;
			}
		}
		rc = xmlTextWriterEndElement(writer);
		if (rc < 0) return 1;
	}
	return 0;
}

int so_ToolSettings_start_element(so_ToolSettings *self, const char *localname, int nb_attributes, const char **attributes)
{
	if (self->in_File) {
		int fail = so_ExternalFile_start_element(self->File[self->num_File - 1], localname, nb_attributes, attributes);
		if (fail) {
			return fail;
		}
	} else if (strcmp(localname, "File") == 0) {
		so_ExternalFile *File = so_ExternalFile_new("File");
		if (!File) {
			return 1;
		}
		int fail = so_ExternalFile_init_attributes(File, nb_attributes, attributes);
		if (fail) {
			so_ExternalFile_free(File);
			return 1;
		}
		fail = so_ToolSettings_add_File(self, File);
		if (fail) {
			so_ExternalFile_free(File);
			return 1;
		}
		self->in_File = 1;
	}
	return 0;
}

void so_ToolSettings_end_element(so_ToolSettings *self, const char *localname)
{
	if (strcmp(localname, "File") == 0 && self->in_File) {
		self->in_File = 0;
	} else if (self->in_File) {
		so_ExternalFile_end_element(self->File[self->num_File - 1], localname);
	}
}

int so_ToolSettings_characters(so_ToolSettings *self, const char *ch, int len)
{
	if (self->in_File) {
		int fail = so_ExternalFile_characters(self->File[self->num_File - 1], ch, len);
		if (fail) return 1;
	}
	return 0;
}
