% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HelperFunctions.R
\name{make_derivative_matrix}
\alias{make_derivative_matrix}
\title{Compute First and Second Derivative Matrices}
\usage{
make_derivative_matrix(
  nc,
  Cpredictors,
  power1_cols,
  power2_cols,
  nonspline_cols,
  interaction_single_cols,
  interaction_quad_cols,
  triplet_cols,
  K,
  include_2way_interactions,
  include_3way_interactions,
  include_quadratic_interactions,
  colnm_expansions,
  expansion_scales,
  just_first_derivatives = FALSE,
  just_spline_effects = TRUE
)
}
\arguments{
\item{nc}{Number of columns}

\item{Cpredictors}{Predictor matrix}

\item{power1_cols}{Indices of linear terms of spline effects}

\item{power2_cols}{Indices of quadratic terms of spline effects}

\item{nonspline_cols}{Indices of non-spline effects}

\item{interaction_single_cols}{Indices of first-order interactions}

\item{interaction_quad_cols}{Indices of quadratic interactions}

\item{triplet_cols}{Indices of three-way interactions}

\item{K}{Number of partitions minus 1 (\eqn{K})}

\item{include_2way_interactions}{Include 2-way interactions}

\item{include_3way_interactions}{Include 3-way interactions}

\item{include_quadratic_interactions}{Include quadratic interactions}

\item{colnm_expansions}{Column names}

\item{expansion_scales}{Scale factors}

\item{just_first_derivatives}{Only compute first derivatives}

\item{just_spline_effects}{Only compute derivatives for spline effects}
}
\value{
List containing first and second derivative matrices
}
\description{
Compute First and Second Derivative Matrices
}
\keyword{internal}
