% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HelperFunctions.R
\name{damped_newton_r}
\alias{damped_newton_r}
\title{Damped Newton-Raphson Parameter Optimization}
\usage{
damped_newton_r(
  parameters,
  loglikelihood,
  gradient,
  neghessian,
  tol = 1e-07,
  max_cnt = 64,
  max_dmp_steps = 16
)
}
\arguments{
\item{parameters}{Initial parameter vector to be optimized}

\item{loglikelihood}{Function computing log-likelihood for current parameters}

\item{gradient}{Function computing parameter gradients}

\item{neghessian}{Function computing negative Hessian matrix}

\item{tol}{Numeric convergence tolerance (default 1e-7)}

\item{max_cnt}{Maximum number of optimization iterations (default 64)}

\item{max_dmp_steps}{Maximum damping step attempts (default 16)}
}
\value{
Optimized parameter estimates after convergence or reaching iteration limit
}
\description{
Performs iterative parameter estimation with adaptive step-size dampening

Internal function for fitting unconstrained GLM models using damped
Newton-Raphson optimization technique.
}
\details{
Implements a robust damped Newton-Raphson optimization algorithm.
}
\seealso{
- \code{\link{nr_iterate}} for parameter update computation
}
\keyword{internal}
