% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_parameters_sc_parallel.R
\name{estimate_parameters_sc_parallel}
\alias{estimate_parameters_sc_parallel}
\title{Estimate parameters of the self-correcting model using log-likelihood maximization in parallel}
\usage{
estimate_parameters_sc_parallel(
  data,
  x_grid = NULL,
  y_grid = NULL,
  t_grid = NULL,
  delta_values = NULL,
  parameter_inits = NULL,
  upper_bounds = NULL,
  opt_algorithm = "NLOPT_LN_SBPLX",
  nloptr_options = list(maxeval = 400, xtol_rel = 1e-05, maxtime = NULL),
  verbose = TRUE,
  num_cores = parallel::detectCores() - 1,
  set_future_plan = FALSE
)
}
\arguments{
\item{data}{a data frame of locations and sizes labelled ("x", "y", "size").}

\item{x_grid}{a vector of grid values for x.}

\item{y_grid}{a vector of grid values for y.}

\item{t_grid}{a vector of grid values for t.}

\item{delta_values}{a vector of delta values.}

\item{parameter_inits}{a vector of parameter initialization values.}

\item{upper_bounds}{a vector of upper bounds for time, x, and y.}

\item{opt_algorithm}{the NLopt algorithm to use for maximization.}

\item{nloptr_options}{a list of named options for nloptr including "maxeval", "xtol_rel", and "maxtime".}

\item{verbose}{`TRUE` or `FALSE` indicating whether to show progress of optimization.}

\item{num_cores}{number of cores to use in parallel estimation.}

\item{set_future_plan}{`TRUE` or `FALSE` indicating whether to change the parallelization plan for use in the function.}
}
\value{
a list containing the optimal obtained values and the full [nloptr::nloptr()] results for all provided delta values.
}
\description{
Estimate the parameters of the self-correcting model using [nloptr::nloptr()] given a set of delta values.
Makes use of parallel computation to allow the user to identify the optimal delta value more quickly
given available computational resources.
}
\details{
Details regarding the self-correcting model and the estimation procedure can be found in the references.
}
\examples{

# Note: This function is designed to be run in parallel and may be computationally intensive.

\donttest{
# Load the small example data
data(small_example_data)

# Define the grid values
x_grid <- seq(0, 25, length.out = 5)
y_grid <- seq(0, 25, length.out = 5)
t_grid <- seq(0, 1, length.out = 5)

# Define the delta values
delta_values <- seq(0.25, 1, by = 0.25)

# Define the parameter initialization values
parameter_inits <- c(1.5, 8.5, .015, 1.5, 3.2, .75, 3, .08)

# Define the upper bounds
upper_bounds <- c(1, 25, 25)

# Estimate the parameters in parallel
estimate_parameters_sc_parallel(
  data = small_example_data,
  x_grid = x_grid,
  y_grid = y_grid,
  t_grid = t_grid,
  delta_values = delta_values,
  parameter_inits = parameter_inits,
  upper_bounds = upper_bounds,
  opt_algorithm = "NLOPT_LN_SBPLX",
  nloptr_options = list(
    maxeval = 50,
    xtol_rel = 1e-2
  ),
  verbose = TRUE,
  set_future_plan = TRUE
)
}

}
\references{
Møller, J., Ghorbani, M., & Rubak, E. (2016). Mechanistic spatio-temporal point process models
for marked point processes, with a view to forest stand data. \emph{Biometrics}, 72(3), 687–696.
\doi{10.1111/biom.12466}.
}
