% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/liouville.R
\name{dliouv}
\alias{dliouv}
\title{Copula function for Liouville copulas}
\usage{
dliouv(x, family, alphavec, theta, is.log = F)
}
\arguments{
\item{x}{sample matrix from a Liouville copula}

\item{family}{family of the Liouville copula. Either \code{"clayton"}, \code{"gumbel"}, \code{"frank"}, \code{"AMH"} or \code{"joe"}}

\item{alphavec}{vector of Dirichlet allocations (must be a vector of integers)}

\item{theta}{parameter of the corresponding Archimedean copula}

\item{is.log}{if \code{TRUE}, will return the log-likelihood value}
}
\value{
value of multivariate density
}
\description{
Copula function for Liouville copulas
}
\examples{
x <- rliouv(n = 100, family = "clayton", alphavec <- c(2,3), theta = 2)
dliouv(x=x, family="clayton", alphavec=c(2,3), theta=2, TRUE)
}

