% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/facebook.R
\name{fb_insights}
\alias{fb_insights}
\title{Facebook Insights API}
\usage{
fb_insights(
  token,
  which,
  start_date = Sys.Date() - 7,
  end_date = Sys.Date(),
  time_increment = "1",
  report_level = "campaign",
  ad_object = "insights",
  breakdowns = NA,
  fields = NA,
  filtering = NULL,
  limit = 100,
  api_version = NULL,
  process = TRUE,
  async = FALSE,
  ...
)
}
\arguments{
\item{token}{Character. Valid access token with sufficient privileges. Visit the
\href{https://developers.facebook.com/tools/explorer}{Facebook API Graph Explorer}
to acquire one.}

\item{which}{Character vector. This is the accounts, campaigns, adsets,
or ads IDs to be queried. Remember: if \code{report_level = "account"}, you must
start the ID with \code{act_}.}

\item{start_date, end_date}{Character. The first and last full day to report, in the
format \code{"YYYY-MM-DD"}.}

\item{time_increment}{Character. Group by months ("monthly"),
everything together ("all_days") or an integer per days [1-90].
Default: each day separately (i.e. "1").}

\item{report_level}{Character. One of "ad", "adset", "campaign", or "account"}

\item{ad_object}{Character. One of: "insights" (default), "adsets", ...}

\item{breakdowns}{Character Vector. One or more of breakdowns for
segmentation results. Set to NA for no breakdowns}

\item{fields}{Character, json format. Leave \code{NA} for default fields OR
\code{NULL} to ignore.}

\item{filtering}{List. Each filter will be a list containing "field",
"operator", and "value". Read more about the operators in the official
\href{https://developers.facebook.com/docs/marketing-api/insights}{docs}.
Example: \code{dplyr::tibble(field = "country", operator = "IN", value = list("PE")))}.}

\item{limit}{Integer. Query limit by pagination.}

\item{api_version}{Character. Facebook API version.}

\item{process}{Boolean. Process GET results to a more friendly format?}

\item{async}{Boolean. Run an async query. When set to \code{TRUE}, instead of making
a GET query, it'll run a POST query and will return a report run ID.}

\item{...}{Additional parameters.}
}
\value{
data.frame with un-nested processed results if \code{process=TRUE} or
raw API results as list when \code{process=FALSE}.
}
\description{
This returns all available FB insights per day including any given
breakdown to the specified report level, and place into a data frame.
For more information on Ad Insights' API, go to the original
\href{https://developers.facebook.com/docs/marketing-api/insights/}{documentaion}.
}
\examples{
\dontrun{
token <- "YOURTOKEN"
which <- "act_20846447"

# Platforms' Insights: all ad-sets platforms of "which" account,
# aggregated, for the last 30 days
platforms <- fb_insights(
  token, which,
  start_date = Sys.Date() - 30,
  time_increment = "all_days",
  report_level = "adset",
  fields = c(
    "account_name",
    "adset_id",
    "adset_start",
    "adset_end"
  ),
  breakdowns = c(
    "publisher_platform",
    "platform_position",
    "device_platform"
  )
)

# Daily results for all campaigns of "which" account,
# with custom performance fields with no breakdowns.
insights_adset <- fb_insights(
  token, which,
  time_increment = "1",
  report_level = "campaign",
  fields = c(
    "adset_id",
    "reach",
    "frequency",
    "spend",
    "cpm",
    "objective",
    "optimization_goal"
  )
)
}
}
\seealso{
Other API: 
\code{\link{bring_api}()},
\code{\link{fb_accounts}()},
\code{\link{fb_ads}()},
\code{\link{fb_creatives}()},
\code{\link{fb_process}()},
\code{\link{fb_report_check}()},
\code{\link{fb_rf}()},
\code{\link{fb_token}()},
\code{\link{gemini_ask}()},
\code{\link{gpt_ask}()},
\code{\link{li_auth}()},
\code{\link{li_profile}()},
\code{\link{queryGA}()},
\code{\link{slackSend}()}

Other Meta: 
\code{\link{fb_accounts}()},
\code{\link{fb_ads}()},
\code{\link{fb_creatives}()},
\code{\link{fb_process}()},
\code{\link{fb_report_check}()},
\code{\link{fb_rf}()},
\code{\link{fb_token}()}
}
\concept{API}
\concept{Meta}
