% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/other_plots.R
\name{noPlot}
\alias{noPlot}
\title{Plot Result with Nothing to Plot}
\usage{
noPlot(message = "Nothing to show here!", size = 4.5, ...)
}
\arguments{
\item{message}{Character. What message do you wish to show?}

\item{size}{Numeric. Font size for \code{message} input.}

\item{...}{Additional parameters passed to \code{theme_lares()}.}
}
\value{
Empty ggplot2 object (with a \code{message} if set).
}
\description{
This function lets the user print a plot without plot, with a
customizable message. It is quite useful for Shiny renderPlot when
using filters and no data is returned.
}
\examples{
Sys.unsetenv("LARES_FONT") # Temporal
noPlot(message = "No plot to show!")
noPlot(background = "#FF5500", size = 7)
}
\seealso{
Other Visualization: 
\code{\link{distr}()},
\code{\link{freqs_df}()},
\code{\link{freqs_list}()},
\code{\link{freqs_plot}()},
\code{\link{freqs}()},
\code{\link{plot_chord}()},
\code{\link{plot_survey}()},
\code{\link{plot_timeline}()},
\code{\link{tree_var}()}
}
\concept{Visualization}
