% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/onehotencoding.R
\name{holidays}
\alias{holidays}
\title{Holidays in your Country}
\usage{
holidays(countries = "Venezuela", years = year(Sys.Date()))
}
\arguments{
\item{countries}{Character or vector. For which country(ies) should the
holidays be imported?}

\item{years}{Character or vector. For which year(s) do you wish to import
holiday dates?}
}
\value{
data.frame with holidays data for given \code{countries} and \code{years}.
}
\description{
This function lets the user automatically scrap holiday dates from
any country and year within +- 5 years. Thanks to timeanddate.com!
}
\examples{
\donttest{
holidays(countries = "Argentina")
holidays(countries = c("Argentina", "Venezuela"), years = c(2019, 2020))
}
}
\seealso{
Other Data Wrangling: 
\code{\link{balance_data}()},
\code{\link{categ_reducer}()},
\code{\link{cleanText}()},
\code{\link{date_cuts}()},
\code{\link{date_feats}()},
\code{\link{formatNum}()},
\code{\link{impute}()},
\code{\link{left}()},
\code{\link{normalize}()},
\code{\link{ohe_commas}()},
\code{\link{ohse}()},
\code{\link{removenacols}()},
\code{\link{replaceall}()},
\code{\link{textFeats}()},
\code{\link{textTokenizer}()},
\code{\link{vector2text}()},
\code{\link{year_month}()}

Other Feature Engineering: 
\code{\link{date_feats}()},
\code{\link{ohse}()}

Other Scrapper: 
\code{\link{filesGD}()},
\code{\link{get_mp3}()},
\code{\link{gtrends_related}()},
\code{\link{ip_data}()},
\code{\link{readGS}()},
\code{\link{splot_etf}()},
\code{\link{stocks_quote}()}

Other One Hot Encoding: 
\code{\link{date_feats}()},
\code{\link{ohe_commas}()},
\code{\link{ohse}()}
}
\concept{Data Wrangling}
\concept{Feature Engineering}
\concept{One Hot Encoding}
\concept{Scrapper}
