% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Methods-LandsepiParams.R
\name{getMatrixCroptypePatho}
\alias{getMatrixCroptypePatho}
\title{Get the "croptype/pathogen genotype" compatibility matrix.}
\usage{
getMatrixCroptypePatho(params)
}
\arguments{
\item{params}{a LandsepiParams object.}
}
\value{
an interaction matrix composed of 0 and 1 values.
}
\description{
Build the matrix indicating if infection is possible at the beginning of the season
for every combination of croptype (rows) and pathogen genotype (columns).
}
\details{
For each croptype, there is either possibility of infection by the pathogen genotype
(value of 1), either complete protection (value of 0)
}
\examples{
\dontrun{
simul_params <- createSimulParams()
gene1 <- loadGene(name = "MG 1", type = "majorGene")
gene2 <- loadGene(name = "MG 2", type = "majorGene")
genes <- data.frame(rbind(gene1, gene2), stringsAsFactors = FALSE)
simul_params <- setGenes(simul_params, genes)
cultivar1 <- loadCultivar(name = "Susceptible", type = "wheat")
cultivar2 <- loadCultivar(name = "Resistant1", type = "wheat")
cultivar3 <- loadCultivar(name = "Resistant2", type = "wheat")
cultivar4 <- loadCultivar(name = "Pyramid", type = "wheat")
cultivars <- data.frame(rbind(cultivar1, cultivar2, cultivar3, cultivar4)
, stringsAsFactors = FALSE)
simul_params <- setCultivars(simul_params, cultivars)
simul_params <- allocateCultivarGenes(simul_params, "Resistant1", c("MG 1"))
simul_params <- allocateCultivarGenes(simul_params, "Resistant2", c("MG 2"))
simul_params <- allocateCultivarGenes(simul_params, "Pyramid", c("MG 1", "MG 2"))
croptypes <- loadCroptypes(simul_params,
                           names = c("Susceptible crop",
                                     "Resistant crop 1",
                                     "Mixture S+R",
                                     "Mixture R1+R2",
                                     "Pyramid crop"))
croptypes <- allocateCroptypeCultivars(croptypes, "Susceptible crop", "Susceptible")
croptypes <- allocateCroptypeCultivars(croptypes, "Resistant crop 1", "Resistant1")
croptypes <- allocateCroptypeCultivars(croptypes, "Mixture S+R", c("Susceptible", "Resistant1"))
croptypes <- allocateCroptypeCultivars(croptypes, "Mixture R1+R2", c("Resistant1", "Resistant2"))
croptypes <- allocateCroptypeCultivars(croptypes, "Pyramid crop", c("Pyramid"))
simul_params <- setCroptypes(simul_params, croptypes)
getMatrixCroptypePatho(simul_params)
}
}
\seealso{
\link{getMatrixGenePatho}, \link{getMatrixCultivarPatho}, \link{getMatrixPolyPatho}
}
