% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/val_labels.R
\name{val_labels}
\alias{val_labels}
\alias{val_labels.default}
\alias{val_labels.haven_labelled}
\alias{val_labels.data.frame}
\alias{val_labels<-}
\alias{val_labels<-.numeric}
\alias{val_labels<-.character}
\alias{val_labels<-.haven_labelled}
\alias{val_labels<-.haven_labelled_spss}
\alias{val_labels<-.data.frame}
\alias{val_label}
\alias{val_label.haven_labelled}
\alias{val_label.data.frame}
\alias{val_label<-}
\alias{val_label<-.haven_labelled}
\alias{val_label<-.numeric}
\alias{val_label<-.character}
\alias{val_label<-.data.frame}
\alias{set_value_labels}
\alias{add_value_labels}
\alias{remove_value_labels}
\title{Get / Set value labels}
\usage{
val_labels(x, prefixed = FALSE)

\method{val_labels}{default}(x, prefixed = FALSE)

\method{val_labels}{haven_labelled}(x, prefixed = FALSE)

\method{val_labels}{data.frame}(x, prefixed = FALSE)

val_labels(x) <- value

\method{val_labels}{numeric}(x) <- value

\method{val_labels}{character}(x) <- value

\method{val_labels}{haven_labelled}(x) <- value

\method{val_labels}{haven_labelled_spss}(x) <- value

\method{val_labels}{data.frame}(x) <- value

val_label(x, v, prefixed = FALSE)

\method{val_label}{haven_labelled}(x, v, prefixed = FALSE)

\method{val_label}{data.frame}(x, v, prefixed = FALSE)

val_label(x, v) <- value

\method{val_label}{haven_labelled}(x, v) <- value

\method{val_label}{numeric}(x, v) <- value

\method{val_label}{character}(x, v) <- value

\method{val_label}{data.frame}(x, v) <- value

set_value_labels(.data, ...)

add_value_labels(.data, ...)

remove_value_labels(.data, ...)
}
\arguments{
\item{x}{A vector.}

\item{prefixed}{Should labels be prefixed with values?}

\item{value}{A named vector for \code{val_labels} (see \code{\link{labelled}}) or a character string
for \code{\link{val_labels}}. \code{NULL} to remove the labels.
For data frames, it could also be a named list.}

\item{v}{A single value.}

\item{.data}{a data frame}

\item{...}{name-value pairs of value labels (see examples)}
}
\value{
\code{val_labels} will return a named vector.
  \code{val_label} will return a single character string.

\code{set_value_labels}, \code{add_value_labels} and \code{remove_value_labels} will return an updated
 copy of \code{.data}.
}
\description{
Get / Set value labels
}
\note{
\code{set_value_labels}, \code{add_value_labels} and \code{remove_value_labels} could be used with \code{dplyr}.
  While \code{set_value_labels} will replace the list of value labels, \code{add_value_labels} and
  \code{remove_value_labels} will update that list (see examples).
}
\examples{
v <- labelled(c(1,2,2,2,3,9,1,3,2,NA), c(yes = 1, no = 3, "don't know" = 9))
val_labels(v)
val_labels(v, prefixed = TRUE)
val_label(v, 2)
val_label(v, 2) <- 'maybe'
val_label(v, 9) <- NULL
val_labels(v) <- NULL
if (require(dplyr)) {
  # setting value labels
  df <- data_frame(s1 = c("M", "M", "F"), s2 = c(1, 1, 2)) \%>\%
    set_value_labels(s1 = c(Male = "M", Female = "F"), s2 = c(Yes = 1, No = 2))
  val_labels(df)

  # updating value labels
  df <- df \%>\% add_value_labels(s2 = c(Unknown = 9))
  df$s2

  # removing a value labels
  df <- df \%>\% remove_value_labels(s2 = 9)
  df$s2

  # removing all value labels
  df <- df \%>\% set_value_labels(s2 = NULL)
  df$s2
}
}
