% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importQualtrics.R
\name{importQualtrics}
\alias{importQualtrics}
\title{Import Qualtrics survey files, apply clean column names}
\usage{
importQualtrics(file, namerow = 1, skip = 3, questrow = NULL,
  dropTEXT = TRUE, stringsAsFactors = FALSE)
}
\arguments{
\item{file}{Character string with file name of a CSV or XLSX file
from Qualtrics.}

\item{namerow}{Default 1, the information to be used as column
names (the HEADER information in R's read.table function)}

\item{skip}{Number of rows to omit because they are not data}

\item{questrow}{Row number to be treated as the questions in the
survey. Usually 2. Default is NULL, meaning questions are not
imported.}

\item{dropTEXT}{Default TRUE, columns ending in "_TEXT" are
omitted.}

\item{stringsAsFactors}{Default FALSE, same meaning as R's
read.csv. Does not affect importation of Excel files.}
}
\value{
Data frame that has attribute "questions" if questrow is
    specified.
}
\description{
Defaults are based on most common format received from Qualtrics
downloads to CSV or XLSX (MS Excel) formats.  We assume that the
file has the column names in row 1 and that 3 rows are skipped
before the real data begins. If the parameter questrow is used, it
designates a row that is interpreted as the survey questions
themselves.  Often, this is in row 2.
}
\author{
Paul Johnson <pauljohn@ku.edu>
}
