% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variableKey.R
\name{varlabTemplate}
\alias{varlabTemplate}
\title{Create Variable Label Template}
\usage{
varlabTemplate(obj, varlab = TRUE)
}
\arguments{
\item{obj}{A variable key}

\item{varlab}{Default NULL, function will start from clean slate,
a set of column labels that match \code{name_new}. User can
specify values by providing a named vector of labels, e.g.,
\code{c("x1" = "happiness", "x2" = "wealth")}, where the names
are values to be matched against "name_new" in key.}
}
\value{
Character matrix with columns \code{name_new} and \code{varlab}.
}
\description{
Receive a key, create a varlab object, with columns
    \code{name_old} \code{name_new}, and \code{varlab}.
}
\details{
If not specified, a matrix is created with empty variable labels.
}
\examples{
mydf.path <- system.file("extdata", "mydf.csv", package = "kutils")
mydf <- read.csv(mydf.path, stringsAsFactors=FALSE)
mydf.keywide1 <- keyTemplate(mydf, long = FALSE, sort = FALSE,
                    varlab = TRUE)
attr(mydf.keywide1, "varlab")
mydf.keywide2 <- keyTemplate(mydf, long = FALSE, sort = FALSE,
                    varlab = c("x3" = "fun"))
attr(mydf.keywide2, "varlab")
attr(mydf.keywide2, "varlab") <- varlabTemplate(mydf.keywide2,
                  varlab = c("x5" = "wealth", "x10" = "happy"))
attr(mydf.keywide2, "varlab")
attr(mydf.keywide2, "varlab") <- varlabTemplate(mydf.keywide2,
                  varlab = TRUE)
attr(mydf.keywide2, "varlab")
## Target we are trying to match:
mydf.keylong <- keyTemplate(mydf, long = TRUE, sort = FALSE, varlab = TRUE)
attr(mydf.keylong, "varlab")
attr(mydf.keylong, "varlab") <- NULL
varlabTemplate(mydf.keylong)
attr(mydf.keylong, "varlab") <- varlabTemplate(mydf.keylong,
                   varlab = c("x3" = "wealth", "x10" = "happy"))
attr(mydf.keylong, "varlab")
attr(mydf.keylong, "varlab") <- varlabTemplate(mydf.keylong, varlab = TRUE)
attr(mydf.keylong, "varlab")
}
\author{
Paul Johnson
}
