% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kmvalidate.R
\name{kmvalidate}
\alias{kmvalidate}
\title{Validate a knowledge structure against a data set}
\usage{
kmvalidate(data, struct)
}
\arguments{
\item{data}{Binary matrix representing a set of response patterns}

\item{struct}{Binary matrix representing a knowledge structure}
}
\value{
A list with three elements:
\describe{
  \item{dist}{Distance distribution vector}
  \item{DI}{Discrepancy Index}
  \item{DA}{Distance Agreement Coefficient}
}
}
\description{
\code{kmvalidate} returns a list with three elements,
a named vector (dist) with the frequencies of distances
between a set of response patterns and a knowledge structure, the
 Discrepancy Index (DI), and the Distance Agreement Coefficient (DA).
}
\section{Warning}{

The DA computation can take quite some time for larger item sets as the
power set has to be computed. For item sets with around 30 items or more,
it may even crash the system due to huge memory requests.
}

\examples{
kmvalidate(xpl$data, xpl$space)

}
\seealso{
Other Validating knowledge spaces: 
\code{\link{kmSRvalidate}()},
\code{\link{kmdist}()}
}
\concept{Validating knowledge spaces}
\keyword{math}
