% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combine_data_across_cols.R
\name{combine_data_across_cols}
\alias{combine_data_across_cols}
\title{Combine data across columns}
\usage{
combine_data_across_cols(data = NULL, cols = NULL)
}
\arguments{
\item{data}{a data object (a data frame or a data.table)}

\item{cols}{a character vector containing names of columns, across
which to combine data}
}
\value{
the output will be a numeric or character vector.
}
\description{
Combine data across columns. If NA is the only value across all focal
columns for given row(s), NA will be returned for those row(s).
}
\examples{
dt <- data.frame(v1 = c(1, NA), v2 = c(NA, 2))
dt
combine_data_across_cols(data = dt, cols = c("v1", "v2"))
dt <- data.frame(v1 = c(1, 2, NA), v2 = c(NA, 4, 3))
dt
combine_data_across_cols(data = dt, cols = c("v1", "v2"))
dt <- data.frame(v1 = c(1, NA, NA), v2 = c(NA, 2, NA))
dt
combine_data_across_cols(data = dt, cols = c("v1", "v2"))
}
