% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_group_means.R
\name{plot_group_means}
\alias{plot_group_means}
\title{Plot group means}
\usage{
plot_group_means(
  data = NULL,
  dv_name = NULL,
  iv_name = NULL,
  na.rm = TRUE,
  error_bar = "ci",
  error_bar_range = 0.95,
  error_bar_tip_width = 0.13,
  error_bar_thickness = 1,
  error_bar_caption = TRUE,
  lines_connecting_means = TRUE,
  line_colors = NULL,
  line_types = NULL,
  line_thickness = 1,
  line_size = NULL,
  dot_size = 3,
  position_dodge = 0.13,
  x_axis_title = NULL,
  y_axis_title = NULL,
  y_axis_title_vjust = 0.85,
  legend_title = NULL,
  legend_position = "right"
)
}
\arguments{
\item{data}{a data object (a data frame or a data.table)}

\item{dv_name}{name of the dependent variable}

\item{iv_name}{name(s) of the independent variable(s).
Up to two independent variables can be supplied.}

\item{na.rm}{logical. If \code{na.rm = TRUE}, NA values in
independent and dependent variables will be removed before
calculating group means.}

\item{error_bar}{if \code{error_bar = "se"}; error bars will be +/-1
standard error, if \code{error_bar = "ci"} error bars will be a
confidence interval; if \code{error_bar = "pi"}, error bars will be
a prediction interval}

\item{error_bar_range}{width of the confidence or prediction interval
(default = 0.95 for 95 percent confidence or prediction interval).
This argument will not apply when \code{error_bar = "se"}}

\item{error_bar_tip_width}{graphically, width of the segments
at the end of error bars (default = 0.13)}

\item{error_bar_thickness}{thickness of the error bars (default = 1)}

\item{error_bar_caption}{should a caption be included to indicate
the width of the error bars? (default = TRUE).}

\item{lines_connecting_means}{logical. Should lines connecting means
within each group be drawn? (default = TRUE)}

\item{line_colors}{colors of the lines connecting means (default = NULL)
If the second IV has two levels, then by default,
\code{line_colors = c("red", "blue")}}

\item{line_types}{types of the lines connecting means (default = NULL)
If the second IV has two levels, then by default,
\code{line_types = c("solid", "dashed")}}

\item{line_thickness}{thickness of the lines connecting group means
(default = 1)}

\item{line_size}{Deprecated. Use the 'linewidth' argument instead.
(default = 1)}

\item{dot_size}{size of the dots indicating group means (default = 3)}

\item{position_dodge}{by how much should the group means and error bars
be horizontally offset from each other so as not to overlap?
(default = 0.13)}

\item{x_axis_title}{a character string for the x-axis title. If no
input is entered, then, by default, the first value of
\code{iv_name} will be used as the x-axis title.}

\item{y_axis_title}{a character string for the y-axis title. If no
input is entered, then, by default, \code{dv_name} will be used
as the y-axis title.}

\item{y_axis_title_vjust}{position of the y axis title (default = 0.85).
By default, \code{y_axis_title_vjust = 0.85}, which means that the
y axis title will be positioned at 85\% of the way up from the bottom
of the plot.}

\item{legend_title}{a character for the legend title. If no input
is entered, then, by default, the second value of \code{iv_name}
will be used as the legend title. If \code{legend_title = FALSE},
then the legend title will be removed.}

\item{legend_position}{position of the legend:
\code{"none", "top", "right", "bottom", "left", "none"}
(default = \code{"right"})}
}
\value{
by default, the output will be a ggplot object.
If \code{output = "table"}, the output will be a data.table object.
}
\description{
Creates a plot of sample means and error bars by group.
}
\examples{
\donttest{
plot_group_means(data = mtcars, dv_name = "mpg", iv_name = c("vs", "am"))
plot_group_means(
  data = mtcars, dv_name = "mpg", iv_name = c("vs", "am"),
  error_bar = "se"
)
plot_group_means(
  data = mtcars, dv_name = "mpg", iv_name = c("vs", "am"),
  error_bar = "pi", error_bar_range = 0.99
)
# set line colors and types manually
plot_group_means(
data = mtcars, dv_name = "mpg", iv_name = c("vs", "am"),
line_colors = c("green4", "purple"),
line_types = c("solid", "solid"))
# remove axis titles
plot_group_means(
data = mtcars, dv_name = "mpg", iv_name = c("vs", "am"),
x_axis_title = FALSE, y_axis_title = FALSE, legend_title = FALSE)
}
}
