% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chi_squared_test.R
\name{chi_squared_test}
\alias{chi_squared_test}
\title{Chi-squared test}
\usage{
chi_squared_test(
  data = NULL,
  iv_name = NULL,
  dv_name = NULL,
  round_chi_sq_test_stat = 2,
  round_p = 3,
  sigfigs_proportion = 2,
  correct = TRUE,
  odds_ratio_ci = 0.95,
  round_odds_ratio_ci_limits = 2,
  invert = FALSE
)
}
\arguments{
\item{data}{a data object (a data frame or a data.table)}

\item{iv_name}{name of the independent variable}

\item{dv_name}{name of the dependent variable (must be a binary variable)}

\item{round_chi_sq_test_stat}{number of decimal places to which to
round the chi-squared test statistic (default = 2)}

\item{round_p}{number of decimal places to which to round the
p-value from the chi-squared test (default = 3)}

\item{sigfigs_proportion}{number of significant digits to round to
(for the table of proportions). By default \code{sigfigs_proportion = 2}}

\item{correct}{logical. Should continuity correction be applied?
(default = TRUE)}

\item{odds_ratio_ci}{width of the confidence interval for the odds ratio.
Input can be any value less than 1 and greater than or equal to 0.
By default, \code{odds_ratio_ci = 0.95}.
If \code{odds_ratio_ci = TRUE}, the default value of 0.95 will be used.
If \code{odds_ratio_ci = FALSE}, no confidence interval will be estimated
for the odds ratio.}

\item{round_odds_ratio_ci_limits}{number of decimal places to which to
round the limits of the odds ratio's confidence interval (default = 2)}

\item{invert}{logical. Whether the inverse of the odds ratio
(i.e., 1 / odds ratio) should be returned.}
}
\description{
Conduct a chi-squared test and produce a contingency table
}
\examples{
chi_squared_test(data = mtcars, iv_name = "cyl", dv_name = "am")
# if the iv has only two levels, odds ratio will also be calculated
chi_squared_test(data = mtcars, iv_name = "vs", dv_name = "am")
}
