% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tabulate_vector.R
\name{tabulate_vector}
\alias{tabulate_vector}
\title{Tabulate vector}
\usage{
tabulate_vector(
  vector = NULL,
  na.rm = TRUE,
  sort_by_decreasing_count = NULL,
  sort_by_increasing_count = NULL,
  sort_by_decreasing_value = NULL,
  sort_by_increasing_value = NULL,
  total_included = TRUE,
  sigfigs = NULL,
  round_digits_after_decimal = NULL,
  output_type = "dt"
)
}
\arguments{
\item{vector}{a character or numeric vector}

\item{na.rm}{if \code{TRUE}, NA values will be removed before calculating
frequencies and proportions.}

\item{sort_by_decreasing_count}{if \code{TRUE}, the output table will
be sorted in the order of decreasing frequency.}

\item{sort_by_increasing_count}{if \code{TRUE}, the output table will
be sorted in the order of increasing frequency.}

\item{sort_by_decreasing_value}{if \code{TRUE}, the output table will
be sorted in the order of decreasing value.}

\item{sort_by_increasing_value}{if \code{TRUE}, the output table will
be sorted in the order of increasing value.}

\item{total_included}{if \code{TRUE}, the output table will include
a row for total counts.}

\item{sigfigs}{number of significant digits to round to}

\item{round_digits_after_decimal}{round to nth digit after decimal
(alternative to \code{sigfigs})}

\item{output_type}{if \code{output_type = "df"}, return a data.frame.
By default, \code{output_type = "dt"}, which will return a data.table.}
}
\value{
a data.table or data.frame
}
\description{
Shows frequency and proportion of unique values in a table format
}
\examples{
tabulate_vector(c("a", "b", "b", "c", "c", "c", NA))
tabulate_vector(c("a", "b", "b", "c", "c", "c", NA),
  sort_by_increasing_count = TRUE
)
tabulate_vector(c("a", "b", "b", "c", "c", "c", NA),
  sort_by_decreasing_value = TRUE
)
tabulate_vector(c("a", "b", "b", "c", "c", "c", NA),
  sort_by_increasing_value = TRUE
)
tabulate_vector(c("a", "b", "b", "c", "c", "c", NA),
  sigfigs = 4
)
tabulate_vector(c("a", "b", "b", "c", "c", "c", NA),
  round_digits_after_decimal = 1
)
tabulate_vector(c("a", "b", "b", "c", "c", "c", NA),
  output_type = "df"
)
}
