% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{metric_sum}
\alias{metric_sum}
\title{Compute the (weighted) sum of the given values.}
\usage{
metric_sum(..., name = "sum", dtype = NULL)
}
\arguments{
\item{...}{For forward/backward compatability.}

\item{name}{(Optional) string name of the metric instance.}

\item{dtype}{(Optional) data type of the metric result.}
}
\value{
a \code{Metric} instance is returned. The \code{Metric} instance can be passed
directly to \code{compile(metrics = )}, or used as a standalone object. See
\code{?Metric} for example usage.
}
\description{
For example, if \code{values} is \verb{[1, 3, 5, 7]} then their sum is 16.
If \code{sample_weight} was specified as \verb{[1, 1, 0, 0]} then the sum would be 4.

This metric creates one variable, \code{total}.
This is ultimately returned as the sum value.
}
\section{Examples}{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{m <- metric_sum()
m$update_state(c(1, 3, 5, 7))
m$result()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## tf.Tensor(16.0, shape=(), dtype=float32)

}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{m <- metric_sum()
m$update_state(c(1, 3, 5, 7), sample_weight = c(1, 1, 0, 0))
m$result()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## tf.Tensor(4.0, shape=(), dtype=float32)

}\if{html}{\out{</div>}}
}

\seealso{
Other reduction metrics: \cr
\code{\link{metric_mean}()} \cr
\code{\link{metric_mean_wrapper}()} \cr

Other metrics: \cr
\code{\link{Metric}()} \cr
\code{\link{custom_metric}()} \cr
\code{\link{metric_auc}()} \cr
\code{\link{metric_binary_accuracy}()} \cr
\code{\link{metric_binary_crossentropy}()} \cr
\code{\link{metric_binary_focal_crossentropy}()} \cr
\code{\link{metric_binary_iou}()} \cr
\code{\link{metric_categorical_accuracy}()} \cr
\code{\link{metric_categorical_crossentropy}()} \cr
\code{\link{metric_categorical_focal_crossentropy}()} \cr
\code{\link{metric_categorical_hinge}()} \cr
\code{\link{metric_concordance_correlation}()} \cr
\code{\link{metric_cosine_similarity}()} \cr
\code{\link{metric_f1_score}()} \cr
\code{\link{metric_false_negatives}()} \cr
\code{\link{metric_false_positives}()} \cr
\code{\link{metric_fbeta_score}()} \cr
\code{\link{metric_hinge}()} \cr
\code{\link{metric_huber}()} \cr
\code{\link{metric_iou}()} \cr
\code{\link{metric_kl_divergence}()} \cr
\code{\link{metric_log_cosh}()} \cr
\code{\link{metric_log_cosh_error}()} \cr
\code{\link{metric_mean}()} \cr
\code{\link{metric_mean_absolute_error}()} \cr
\code{\link{metric_mean_absolute_percentage_error}()} \cr
\code{\link{metric_mean_iou}()} \cr
\code{\link{metric_mean_squared_error}()} \cr
\code{\link{metric_mean_squared_logarithmic_error}()} \cr
\code{\link{metric_mean_wrapper}()} \cr
\code{\link{metric_one_hot_iou}()} \cr
\code{\link{metric_one_hot_mean_iou}()} \cr
\code{\link{metric_pearson_correlation}()} \cr
\code{\link{metric_poisson}()} \cr
\code{\link{metric_precision}()} \cr
\code{\link{metric_precision_at_recall}()} \cr
\code{\link{metric_r2_score}()} \cr
\code{\link{metric_recall}()} \cr
\code{\link{metric_recall_at_precision}()} \cr
\code{\link{metric_root_mean_squared_error}()} \cr
\code{\link{metric_sensitivity_at_specificity}()} \cr
\code{\link{metric_sparse_categorical_accuracy}()} \cr
\code{\link{metric_sparse_categorical_crossentropy}()} \cr
\code{\link{metric_sparse_top_k_categorical_accuracy}()} \cr
\code{\link{metric_specificity_at_sensitivity}()} \cr
\code{\link{metric_squared_hinge}()} \cr
\code{\link{metric_top_k_categorical_accuracy}()} \cr
\code{\link{metric_true_negatives}()} \cr
\code{\link{metric_true_positives}()} \cr
}
\concept{metrics}
\concept{reduction metrics}
