% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resp01_functions.R
\name{resp01_a_comp_stat_logical}
\alias{resp01_a_comp_stat_logical}
\title{Formatted Analysis Function for Comparative Statistic in Response Tables (RESP01)}
\usage{
resp01_a_comp_stat_logical(
  df,
  .var,
  conf_level,
  include,
  arm,
  strata,
  formats,
  methods,
  stat = c("comp_stat_ci", "pval")
)
}
\arguments{
\item{df}{(\code{data.frame})\cr data set containing all analysis variables.}

\item{.var}{(\code{string})\cr single variable name that is passed by \code{rtables} when requested
by a statistics function.}

\item{conf_level}{(\code{proportion})\cr confidence level of the interval.}

\item{include}{(\code{flag})\cr whether to include the results for this variable.}

\item{arm}{(\code{string})\cr column name in the data frame that identifies the treatment arms.}

\item{strata}{(\code{character} or \code{NULL})\cr variable names indicating stratification factors.}

\item{formats}{(\code{list})\cr containing formats for \code{comp_stat_ci} and \code{pval}.}

\item{methods}{(\code{list})\cr containing methods for comparative statistics. The element \code{comp_stat_ci} can be
'rr' (relative risk), 'or_cmh' (odds ratio with CMH estimation and p-value) or 'or_logistic' (odds ratio
estimated by conditional or standard logistic regression). The element \code{pval} can be 'fisher' (Fisher's
exact test) or 'chisq' (chi-square test), only used when using unstratified analyses with 'or_logistic'.}

\item{stat}{(\code{string})\cr the statistic to return, either \code{comp_stat_ci}
or \code{pval}.}
}
\value{
The formatted result as \code{\link[rtables:rcell]{rtables::rcell()}}.
}
\description{
This function applies to a \code{logical} column called \code{.var} from \code{df}.
The response proportion is compared between the treatment arms identified
by column \code{arm}.
}
\examples{
dm <- droplevels(subset(formatters::DM, SEX \%in\% c("F", "M")))
dm$RESP <- as.logical(sample(c(TRUE, FALSE), size = nrow(DM), replace = TRUE))

resp01_a_comp_stat_logical(
  dm,
  .var = "RESP",
  conf_level = 0.9,
  include = TRUE,
  arm = "SEX",
  strata = "RACE",
  stat = "comp_stat_ci",
  methods = list(comp_stat_ci = "or_cmh"),
  formats = list(
    comp_stat_ci = jjcsformat_xx("xx.xx (xx.xx - xx.xx)"),
    pval = jjcsformat_pval_fct(0.05)
  )
)
}
\seealso{
\code{\link[=resp01_a_comp_stat_factor]{resp01_a_comp_stat_factor()}} for the \code{factor} equivalent.
}
